/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.xmlsec.EncryptionParameters;

public class EncryptionAlgorithmAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionContextLookupStrategy;

    public EncryptionAlgorithmAuditExtractor() {
        Function ecls = new ChildContextLookup(EncryptionContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (ecls != null);
        this.encryptionContextLookupStrategy = ecls;
    }

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        this.encryptionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        EncryptionContext encryptionCtx = this.encryptionContextLookupStrategy.apply(input);
        if (encryptionCtx != null) {
            EncryptionParameters assertionParams = encryptionCtx.getAssertionEncryptionParameters();
            if (assertionParams != null) {
                return assertionParams.getDataEncryptionAlgorithm();
            }
            EncryptionParameters attributeParams = encryptionCtx.getAttributeEncryptionParameters();
            if (attributeParams != null) {
                return attributeParams.getDataEncryptionAlgorithm();
            }
            EncryptionParameters idParams = encryptionCtx.getIdentifierEncryptionParameters();
            if (idParams != null) {
                return idParams.getDataEncryptionAlgorithm();
            }
        }
        return null;
    }
}

