/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.saml.profile.impl.BaseAddAttributeStatementToAssertion;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Attribute;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.profile.SAML1ActionSupport;
import org.slf4j.Logger;

public class AddAttributeStatementToAssertion
extends BaseAddAttributeStatementToAssertion<Attribute> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAttributeStatementToAssertion.class);
    @Nonnull
    private Function<ProfileRequestContext, Assertion> assertionLookupStrategy = new AssertionStrategy();

    public void setAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        this.checkSetterPreconditions();
        this.assertionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            AttributeStatement statement = this.buildAttributeStatement(profileRequestContext, this.getAttributeContext().getIdPAttributes().values());
            if (statement == null) {
                this.log.debug("{} No AttributeStatement was built, nothing to do", (Object)this.getLogPrefix());
                return;
            }
            Assertion assertion = this.assertionLookupStrategy.apply(profileRequestContext);
            if (assertion == null) {
                this.log.error("Unable to obtain Assertion to modify");
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
                return;
            }
            assertion.getAttributeStatements().add(statement);
            this.log.debug("{} Adding constructed AttributeStatement to Assertion {} ", (Object)this.getLogPrefix(), (Object)assertion.getID());
        }
        catch (AttributeEncodingException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncodeAttribute");
        }
    }

    @Nullable
    private AttributeStatement buildAttributeStatement(@Nonnull ProfileRequestContext profileRequestContext, @Nullable @NullableElements Collection<IdPAttribute> attributes) throws AttributeEncodingException {
        if (attributes == null || attributes.isEmpty()) {
            this.log.debug("{} No attributes available to be encoded, nothing to do", (Object)this.getLogPrefix());
            return null;
        }
        ArrayList<Attribute> encodedAttributes = new ArrayList<Attribute>(attributes.size());
        try (ServiceableComponent component = this.getTranscoderRegistry().getServiceableComponent();){
            for (IdPAttribute attribute : attributes) {
                if (attribute == null || attribute.getValues().isEmpty()) continue;
                this.encodeAttribute((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, attribute, encodedAttributes);
            }
        }
        catch (ServiceException e) {
            throw new AttributeEncodingException("Attribute transoding service unavailable", (Exception)((Object)e));
        }
        if (encodedAttributes.isEmpty()) {
            this.log.debug("{} No attributes were encoded as SAML 1 Attributes, nothing to do", (Object)this.getLogPrefix());
            return null;
        }
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement statement = (AttributeStatement)statementBuilder.buildObject();
        for (Attribute attribute : encodedAttributes) {
            assert (attribute != null);
            Attribute existing = this.findExistingAttribute(statement, attribute);
            if (existing != null) {
                Iterator newValues = attribute.getAttributeValues().iterator();
                while (newValues.hasNext()) {
                    XMLObject newValue = (XMLObject)newValues.next();
                    newValues.remove();
                    existing.getAttributeValues().add(newValue);
                }
                continue;
            }
            statement.getAttributes().add(attribute);
        }
        return statement;
    }

    @Nullable
    private Attribute findExistingAttribute(@Nonnull AttributeStatement statement, @Nonnull Attribute newAttribute) {
        for (Attribute attr : statement.getAttributes()) {
            if (!Objects.equals(attr.getAttributeName(), newAttribute.getAttributeName()) || !Objects.equals(attr.getAttributeNamespace(), newAttribute.getAttributeNamespace())) continue;
            return attr;
        }
        return null;
    }

    private void encodeAttribute(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull Collection<Attribute> results) throws AttributeEncodingException {
        this.log.debug("{} Attempting to encode attribute {} as a SAML 1 Attribute", (Object)this.getLogPrefix(), (Object)attribute.getId());
        if (super.encodeAttribute(registry, profileRequestContext, attribute, Attribute.class, results) == 0) {
            this.log.debug("{} Attribute {} did not have SAML 1 Attribute transcoder instructions associated, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
        }
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, Assertion> {
        private AssertionStrategy() {
        }

        @Override
        @Nullable
        public Assertion apply(@Nullable ProfileRequestContext input) {
            MessageContext omc;
            MessageContext messageContext = omc = input == null ? null : input.getOutboundMessageContext();
            if (input != null && omc != null) {
                Object outboundMessage = omc.getMessage();
                if (outboundMessage == null) {
                    Assertion ret = SAML1ActionSupport.buildAssertion((AbstractProfileAction)AddAttributeStatementToAssertion.this, (IdentifierGenerationStrategy)AddAttributeStatementToAssertion.this.getIdGenerator(), (String)AddAttributeStatementToAssertion.this.getIssuerId());
                    omc.setMessage((Object)ret);
                    return ret;
                }
                if (outboundMessage instanceof Assertion) {
                    return (Assertion)outboundMessage;
                }
                if (outboundMessage instanceof Response) {
                    if (AddAttributeStatementToAssertion.this.isStatementInOwnAssertion() || ((Response)outboundMessage).getAssertions().isEmpty()) {
                        return SAML1ActionSupport.addAssertionToResponse((AbstractProfileAction)AddAttributeStatementToAssertion.this, (Response)((Response)outboundMessage), (IdentifierGenerationStrategy)AddAttributeStatementToAssertion.this.getIdGenerator(), (String)AddAttributeStatementToAssertion.this.getIssuerId());
                    }
                    return (Assertion)((Response)outboundMessage).getAssertions().get(0);
                }
            }
            return null;
        }
    }
}

