/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.impl;

import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.impl.AbstractSAML2ArtifactAwareProfileConfiguration;
import net.shibboleth.saml.profile.config.SAMLAssertionProducingProfileConfiguration;
import net.shibboleth.saml.saml2.profile.config.SAML2AssertionProducingProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML2AssertionProducingProfileConfiguration
extends AbstractSAML2ArtifactAwareProfileConfiguration
implements SAML2AssertionProducingProfileConfiguration {
    @Nonnull
    private Predicate<ProfileRequestContext> signAssertionsPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> includeNotBeforePredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Function<ProfileRequestContext, Duration> assertionLifetimeLookupStrategy = FunctionSupport.constant((Object)SAMLAssertionProducingProfileConfiguration.DEFAULT_ASSERTION_LIFETIME);
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> additionalAudiencesLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> encryptAssertionsPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptAttributesPredicate = PredicateSupport.alwaysFalse();

    public AbstractSAML2AssertionProducingProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public boolean isSignAssertions(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signAssertionsPredicate.test(profileRequestContext);
    }

    public void setSignAssertions(boolean flag) {
        this.signAssertionsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setSignAssertionsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    public boolean isIncludeConditionsNotBefore(@Nullable ProfileRequestContext profileRequestContext) {
        return this.includeNotBeforePredicate.test(profileRequestContext);
    }

    public void setIncludeConditionsNotBefore(boolean flag) {
        this.includeNotBeforePredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setIncludeConditionsNotBeforePredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.includeNotBeforePredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nonnull
    public Duration getAssertionLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.assertionLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isNotNull((Object)lifetime, (String)"Assertion lifetime cannot be null");
        Constraint.isFalse((lifetime.isNegative() || lifetime.isZero() ? 1 : 0) != 0, (String)"Assertion lifetime must be greater than 0");
        return lifetime;
    }

    public void setAssertionLifetime(@Nonnull Duration lifetime) {
        Constraint.isNotNull((Object)lifetime, (String)"Assertion lifetime cannot be null");
        Constraint.isFalse((lifetime.isNegative() || lifetime.isZero() ? 1 : 0) != 0, (String)"Assertion lifetime must be greater than 0");
        this.assertionLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setAssertionLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.assertionLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getAssertionAudiences(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> audiences = this.additionalAudiencesLookupStrategy.apply(profileRequestContext);
        if (audiences != null) {
            return CollectionSupport.copyToSet(audiences);
        }
        return CollectionSupport.emptySet();
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public void setAdditionalAudiencesForAssertion(@Nullable Collection<String> audiences) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setAdditionalAudiencesForAssertion", (String)"relying-party.xml", (String)"setAdditionalAudiences");
        this.setAssertionAudiences(audiences);
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public void setAdditionalAudiencesForAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setAdditionalAudiencesForAssertionLookupStrategy", (String)"relying-party.xml", (String)"setAdditionalAudiences");
        this.setAssertionAudiencesLookupStrategy(strategy);
    }

    public void setAssertionAudiences(@Nullable Collection<String> audiences) {
        this.additionalAudiencesLookupStrategy = audiences == null || audiences.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant((Object)CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(audiences)));
    }

    public void setAssertionAudiencesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.additionalAudiencesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isEncryptAssertions(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptAssertionsPredicate.test(profileRequestContext);
    }

    public void setEncryptAssertions(boolean flag) {
        this.encryptAssertionsPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setEncryptAssertionsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    public boolean isEncryptAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptAttributesPredicate.test(profileRequestContext);
    }

    public void setEncryptAttributes(boolean flag) {
        this.encryptAttributesPredicate = PredicateSupport.constant((boolean)flag);
    }

    public void setEncryptAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptAttributesPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }
}

