/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.saml.saml2.profile.impl.SAMLAuthnContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.slf4j.Logger;

public class ContinueSAMLAuthentication
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ContinueSAMLAuthentication.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        StatusCode statusCode;
        MessageContext imc;
        ExternalAuthenticationContext extContext = (ExternalAuthenticationContext)authenticationContext.getSubcontext(ExternalAuthenticationContext.class);
        if (extContext == null) {
            this.log.debug("{} No ExternalAuthenticationContext available within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return;
        }
        MessageContext messageContext = imc = profileRequestContext != null ? profileRequestContext.getInboundMessageContext() : null;
        assert (extContext != null);
        String authnError = extContext.getAuthnError();
        if (authnError != null) {
            this.log.info("{} SAML authentication attempt signaled an error: {}", (Object)this.getLogPrefix(), (Object)authnError);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)authnError);
            return;
        }
        if (imc == null) {
            this.log.info("{} No inbound SAML Response found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        Response response = (Response)imc.getMessage();
        if (response == null || !(response instanceof Response)) {
            this.log.info("{} Inbound message was not a SAML Response", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            return;
        }
        Status status = response.getStatus();
        StatusCode statusCode2 = statusCode = status == null ? null : status.getStatusCode();
        if (status == null || statusCode == null || statusCode.getValue() == null) {
            this.log.info("{} SAML response did not contain a StatusCode", (Object)this.getLogPrefix());
            authenticationContext.removeSubcontext(SAMLAuthnContext.class);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            return;
        }
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode.getValue())) {
            this.log.info("{} SAML response contained error status: {}", (Object)this.getLogPrefix(), (Object)statusCode.getValue());
            authenticationContext.removeSubcontext(SAMLAuthnContext.class);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            return;
        }
    }
}

