/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.saml.saml2.profile.config.ArtifactResolutionProfileConfiguration;
import net.shibboleth.saml.saml2.profile.config.SAML2AssertionProducingProfileConfiguration;
import net.shibboleth.saml.saml2.profile.config.SAML2ProfileConfiguration;
import net.shibboleth.saml.saml2.profile.config.SingleLogoutProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.slf4j.Logger;

public class PopulateEncryptionParameters
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateEncryptionParameters.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionContextLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, SAMLPeerEntityContext> peerContextLookupStrategy;
    @Nullable
    private String samlProtocol;
    @Nullable
    private QName peerRole;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<EncryptionConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private EncryptionParametersResolver encParamsresolver;
    @Nullable
    private List<EncryptionConfiguration> encryptionConfigurations;
    private boolean encryptionOptional;
    private boolean encryptAssertions;
    private boolean encryptIdentifiers;
    private boolean encryptAttributes;

    public PopulateEncryptionParameters() {
        Function ecls = new ChildContextLookup(EncryptionContext.class, true).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        assert (ecls != null);
        this.encryptionContextLookupStrategy = ecls;
        Function pcls = new ChildContextLookup(SAMLPeerEntityContext.class).compose((Function)new OutboundMessageContextLookup());
        assert (pcls != null);
        this.peerContextLookupStrategy = pcls;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        this.checkSetterPreconditions();
        this.encryptionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    public void setProtocol(@Nullable String protocol) {
        this.samlProtocol = StringSupport.trimOrNull((String)protocol);
    }

    public void setRole(@Nullable QName role) {
        this.peerRole = role;
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<EncryptionConfiguration>> strategy) {
        this.checkSetterPreconditions();
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionConfiguration lookup strategy cannot be null");
    }

    public void setPeerContextLookupStrategy(@Nullable Function<ProfileRequestContext, SAMLPeerEntityContext> strategy) {
        this.checkSetterPreconditions();
        this.peerContextLookupStrategy = strategy;
    }

    public void setEncryptionParametersResolver(@Nonnull EncryptionParametersResolver newResolver) {
        this.checkSetterPreconditions();
        this.encParamsresolver = (EncryptionParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"EncryptionParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.encParamsresolver == null) {
            throw new ComponentInitializationException("EncryptionParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<ProfileRequestContext, List<EncryptionConfiguration>>(){

                @Override
                public List<EncryptionConfiguration> apply(ProfileRequestContext input) {
                    return CollectionSupport.singletonList((Object)SecurityConfigurationSupport.ensureGlobalEncryptionConfiguration());
                }
            };
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpContext == null) {
            this.log.debug("{} Unable to locate RelyingPartyContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (!(rpContext.getProfileConfig() instanceof SAML2ProfileConfiguration)) {
            this.log.debug("{} Not a SAML 2 profile configuration, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        MessageContext imc = profileRequestContext.getInboundMessageContext();
        Object msg = null;
        if (imc != null) {
            msg = imc.getMessage();
        }
        if (msg instanceof AuthnRequest) {
            String requestedFormat;
            AuthnRequest req = (AuthnRequest)msg;
            NameIDPolicy policy = req.getNameIDPolicy();
            if (policy != null && (requestedFormat = policy.getFormat()) != null && "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equals(requestedFormat)) {
                this.log.debug("{} Request asked for encrypted identifier, disregarding installed predicate");
                this.encryptIdentifiers = true;
            }
        } else if (msg != null && rpContext.getProfileConfig() instanceof SingleLogoutProfileConfiguration) {
            this.log.debug("{} Inbound logout message, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        SAML2ProfileConfiguration profileConfiguration = (SAML2ProfileConfiguration)rpContext.getProfileConfig();
        assert (profileConfiguration != null);
        if (!this.encryptIdentifiers) {
            this.encryptIdentifiers = profileConfiguration.isEncryptNameIDs(profileRequestContext);
            this.encryptionOptional = profileConfiguration.isEncryptionOptional(profileRequestContext);
        }
        if (profileConfiguration instanceof SAML2AssertionProducingProfileConfiguration) {
            SAML2AssertionProducingProfileConfiguration appc = (SAML2AssertionProducingProfileConfiguration)profileConfiguration;
            this.encryptAssertions = appc.isEncryptAssertions(profileRequestContext);
            this.encryptAttributes = appc.isEncryptAttributes(profileRequestContext);
        } else if (profileConfiguration instanceof ArtifactResolutionProfileConfiguration) {
            ArtifactResolutionProfileConfiguration arpc = (ArtifactResolutionProfileConfiguration)profileConfiguration;
            this.encryptAssertions = arpc.isEncryptAssertions(profileRequestContext);
            this.encryptAttributes = arpc.isEncryptAttributes(profileRequestContext);
        }
        if (!(this.encryptAssertions || this.encryptIdentifiers || this.encryptAttributes)) {
            this.log.debug("{} No encryption requested, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.encryptionConfigurations = this.configurationLookupStrategy.apply(profileRequestContext);
        this.log.debug("{} Encryption for assertions ({}), identifiers ({}), attributes({})", new Object[]{this.getLogPrefix(), this.encryptAssertions, this.encryptIdentifiers, this.encryptAttributes});
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Resolving EncryptionParameters for request", (Object)this.getLogPrefix());
        EncryptionContext encryptCtx = this.encryptionContextLookupStrategy.apply(profileRequestContext);
        if (encryptCtx == null) {
            this.log.debug("{} No EncryptionContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        try {
            List<EncryptionConfiguration> configs = this.encryptionConfigurations;
            if (configs == null || configs.isEmpty()) {
                throw new ResolverException("No EncryptionConfigurations returned by lookup strategy");
            }
            EncryptionParameters params = (EncryptionParameters)this.encParamsresolver.resolveSingle((Object)this.buildCriteriaSet(profileRequestContext, configs));
            this.log.debug("{} {} EncryptionParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
            if (params != null) {
                if (this.encryptAssertions) {
                    encryptCtx.setAssertionEncryptionParameters(params);
                }
                if (this.encryptIdentifiers) {
                    encryptCtx.setIdentifierEncryptionParameters(params);
                }
                if (this.encryptAttributes) {
                    encryptCtx.setAttributeEncryptionParameters(params);
                }
            } else if (this.encryptionOptional) {
                this.log.debug("{} Resolver returned no EncryptionParameters", (Object)this.getLogPrefix());
                this.log.debug("{} Encryption is optional, ignoring inability to encrypt", (Object)this.getLogPrefix());
            } else {
                this.log.warn("{} Resolver returned no EncryptionParameters", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            }
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving EncryptionParameters", (Object)this.getLogPrefix(), (Object)e);
            if (this.encryptionOptional) {
                this.log.debug("{} Encryption is optional, ignoring inability to encrypt", (Object)this.getLogPrefix());
            }
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
        }
    }

    @Nonnull
    private CriteriaSet buildCriteriaSet(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull List<EncryptionConfiguration> configurations) {
        SAMLPeerEntityContext peerCtx;
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EncryptionConfigurationCriterion(configurations)});
        criteria.add((Object)new EncryptionOptionalCriterion(this.encryptionOptional));
        if (this.peerContextLookupStrategy != null && (peerCtx = this.peerContextLookupStrategy.apply(profileRequestContext)) != null) {
            SAMLMetadataContext metadataCtx;
            RoleDescriptor roleDescriptor;
            String peerEntityId = peerCtx.getEntityId();
            if (peerEntityId != null) {
                this.log.debug("{} Adding entityID to resolution criteria", (Object)this.getLogPrefix());
                criteria.add((Object)new EntityIdCriterion(peerEntityId));
                if (this.samlProtocol != null) {
                    criteria.add((Object)new ProtocolCriterion(this.samlProtocol));
                }
                if (this.peerRole != null) {
                    criteria.add((Object)new EntityRoleCriterion(this.peerRole));
                }
            }
            RoleDescriptor roleDescriptor2 = roleDescriptor = (metadataCtx = (SAMLMetadataContext)peerCtx.getSubcontext(SAMLMetadataContext.class)) == null ? null : metadataCtx.getRoleDescriptor();
            if (roleDescriptor != null) {
                this.log.debug("{} Adding role metadata to resolution criteria", (Object)this.getLogPrefix());
                criteria.add((Object)new RoleDescriptorCriterion(roleDescriptor));
            }
        }
        return criteria;
    }
}

