/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SPSessionEx;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class LogoutPropagationFlowDescriptor
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private final Class<? extends SPSession> sessionType;

    public LogoutPropagationFlowDescriptor(@ParameterName(name="type") Class<? extends SPSession> type) {
        this.sessionType = (Class)Constraint.isNotNull(type, (String)"SPSession type cannot be null");
    }

    @Nonnull
    public Class<? extends SPSession> getSessionType() {
        return this.sessionType;
    }

    public boolean isSupported(@Nonnull SPSession session) {
        if (this.sessionType.isInstance(session)) {
            if (session instanceof SPSessionEx) {
                return ((SPSessionEx)session).supportsLogoutPropagation();
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof LogoutPropagationFlowDescriptor) {
            return this.getId().equals(((LogoutPropagationFlowDescriptor)((Object)obj)).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("flowId", (Object)this.getId()).toString();
    }
}

