/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.logic;

import com.google.common.net.InetAddresses;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.IPRange;

public class IPRangeBiPredicate
implements BiPredicate<String, String> {
    @Nonnull
    @NonnullElements
    private Collection<IPRange> addressRanges = List.of();

    IPRangeBiPredicate() {
    }

    public void setRanges(@Nonnull @NonnullElements Collection<IPRange> ranges) {
        Constraint.isNotNull(ranges, (String)"Address range collection cannot be null");
        this.addressRanges = List.copyOf(ranges);
    }

    @Override
    public boolean test(@Nullable String input1, @Nullable String input2) {
        if (input1 == null || input2 == null) {
            return false;
        }
        if (input1.equals(input2)) {
            return true;
        }
        for (IPRange range : this.addressRanges) {
            if (!range.contains(InetAddresses.forString((String)input1)) || !range.contains(InetAddresses.forString((String)input2))) continue;
            return true;
        }
        return false;
    }
}

