/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import java.time.Instant;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.IdentifiedComponent;

@ThreadSafe
public interface IdPSession
extends IdentifiedComponent {
    @Nonnull
    @NotEmpty
    public static final String MDC_ATTRIBUTE = "idp.session.id";

    @Nonnull
    @NotEmpty
    public String getPrincipalName();

    @Nonnull
    public Instant getCreationInstant();

    @Nonnull
    public Instant getLastActivityInstant();

    public boolean checkAddress(@Nonnull @NotEmpty String var1) throws SessionException;

    public boolean checkTimeout() throws SessionException;

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<AuthenticationResult> getAuthenticationResults();

    @Nullable
    public AuthenticationResult getAuthenticationResult(@Nonnull @NotEmpty String var1);

    @Nullable
    public AuthenticationResult addAuthenticationResult(@Nonnull AuthenticationResult var1) throws SessionException;

    public void updateAuthenticationResultActivity(@Nonnull AuthenticationResult var1) throws SessionException;

    public boolean removeAuthenticationResult(@Nonnull AuthenticationResult var1) throws SessionException;

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<SPSession> getSPSessions();

    @Nullable
    public SPSession getSPSession(@Nonnull @NotEmpty String var1);

    @Nullable
    public SPSession addSPSession(@Nonnull SPSession var1) throws SessionException;

    public boolean removeSPSession(@Nonnull SPSession var1) throws SessionException;
}

