/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import com.google.common.base.MoreObjects;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

@ThreadSafe
public abstract class AbstractIdPSession
implements IdPSession {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractIdPSession.class);
    @Nonnull
    @NotEmpty
    private final String id;
    @Nonnull
    @NotEmpty
    private final String principalName;
    @Nonnull
    private final Instant creationInstant;
    @Nonnull
    private Instant lastActivityInstant;
    @Nullable
    private String ipV4Address;
    @Nullable
    private String ipV6Address;
    @Nullable
    private String unknownAddress;
    @Nonnull
    private final ConcurrentMap<String, Optional<AuthenticationResult>> authenticationResults;
    @Nonnull
    private final ConcurrentMap<String, Optional<SPSession>> spSessions;

    public AbstractIdPSession(@Nonnull @NotEmpty String sessionId, @Nonnull @NotEmpty String canonicalName, @Nonnull Instant creationTime) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sessionId), (String)"Session ID cannot be null or empty");
        this.principalName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)canonicalName), (String)"Principal name cannot be null or empty.");
        this.creationInstant = (Instant)Constraint.isNotNull((Object)creationTime, (String)"Creation time cannot be null");
        this.lastActivityInstant = creationTime;
        this.authenticationResults = new ConcurrentHashMap<String, Optional<AuthenticationResult>>(5);
        this.spSessions = new ConcurrentHashMap<String, Optional<SPSession>>(10);
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getPrincipalName() {
        return this.principalName;
    }

    @Override
    @Nonnull
    public Instant getCreationInstant() {
        return this.creationInstant;
    }

    @Override
    @Nonnull
    public Instant getLastActivityInstant() {
        return this.lastActivityInstant;
    }

    public void setLastActivityInstant(@Nonnull Instant instant) throws SessionException {
        this.doSetLastActivityInstant(instant);
    }

    public void doSetLastActivityInstant(@Nonnull Instant instant) {
        this.lastActivityInstant = (Instant)Constraint.isNotNull((Object)instant, (String)"Last activity instant cannot be null");
    }

    @Override
    public boolean checkAddress(@Nonnull @NotEmpty String address) throws SessionException {
        AddressFamily family = AbstractIdPSession.getAddressFamily(address);
        String bound = this.getAddress(family);
        if (bound != null) {
            if (!bound.equals(address)) {
                this.log.warn("Client address is {} but session {} already bound to {}", new Object[]{address, this.id, bound});
                return false;
            }
        } else {
            this.log.info("Session {} not yet locked to {} address, locking it to {}", new Object[]{this.id, family, address});
            try {
                this.bindToAddress(address);
            }
            catch (SessionException e) {
                this.log.error("Unable to bind session {} to address {}", (Object)this.id, (Object)address);
                return false;
            }
        }
        return true;
    }

    @Nullable
    public String getAddress(@Nonnull AddressFamily family) {
        switch (family) {
            case IPV4: {
                return this.ipV4Address;
            }
            case IPV6: {
                return this.ipV6Address;
            }
            case UNKNOWN: {
                return this.unknownAddress;
            }
        }
        return null;
    }

    public void bindToAddress(@Nonnull @NotEmpty String address) throws SessionException {
        this.doBindToAddress(address);
    }

    public void doBindToAddress(@Nonnull @NotEmpty String address) {
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)address), (String)"Address cannot be null or empty");
        switch (AbstractIdPSession.getAddressFamily(address)) {
            case IPV6: {
                this.ipV6Address = StringSupport.trimOrNull((String)trimmed);
                break;
            }
            case IPV4: {
                this.ipV4Address = StringSupport.trimOrNull((String)trimmed);
                break;
            }
            case UNKNOWN: {
                this.unknownAddress = StringSupport.trimOrNull((String)trimmed);
                break;
            }
            default: {
                this.log.warn("Unsupported address form {}", (Object)address);
            }
        }
    }

    @Override
    public boolean checkTimeout() throws SessionException {
        this.setLastActivityInstant(Instant.now());
        return true;
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<AuthenticationResult> getAuthenticationResults() {
        return (Set)((NonnullSupplier)this.authenticationResults.values().stream().filter(Optional::isPresent).map(Optional::orElseThrow).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
    }

    @Override
    @Nullable
    public AuthenticationResult getAuthenticationResult(@Nonnull @NotEmpty String flowId) {
        Optional mapped = (Optional)this.authenticationResults.get(StringSupport.trimOrNull((String)flowId));
        return mapped != null ? (AuthenticationResult)mapped.orElse(null) : null;
    }

    @Override
    @Nullable
    public AuthenticationResult addAuthenticationResult(@Nonnull AuthenticationResult result) throws SessionException {
        return this.doAddAuthenticationResult(result);
    }

    @Override
    public boolean removeAuthenticationResult(@Nonnull AuthenticationResult result) throws SessionException {
        return this.doRemoveAuthenticationResult(result);
    }

    @Nullable
    public AuthenticationResult doAddAuthenticationResult(@Nonnull AuthenticationResult result) {
        Constraint.isNotNull((Object)result, (String)"AuthenticationResult cannot be null");
        Optional<AuthenticationResult> prev = this.authenticationResults.put(result.getAuthenticationFlowId(), Optional.of(result));
        if (prev != null && prev.isPresent()) {
            this.log.debug("IdPSession {}: replaced old AuthenticationResult for flow ID {}", (Object)this.id, (Object)prev.get().getAuthenticationFlowId());
            return prev.get();
        }
        return null;
    }

    public boolean doRemoveAuthenticationResult(@Nonnull AuthenticationResult result) {
        Constraint.isNotNull((Object)result, (String)"Authentication event can not be null");
        if (this.authenticationResults.remove(result.getAuthenticationFlowId(), Optional.of(result))) {
            return true;
        }
        return this.authenticationResults.remove(result.getAuthenticationFlowId(), Optional.empty());
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<SPSession> getSPSessions() {
        return (Set)((NonnullSupplier)this.spSessions.values().stream().filter(Optional::isPresent).map(Optional::orElseThrow).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
    }

    @Override
    @Nullable
    public SPSession getSPSession(@Nonnull @NotEmpty String serviceId) {
        Optional mapped = (Optional)this.spSessions.get(StringSupport.trimOrNull((String)serviceId));
        return mapped != null ? (SPSession)mapped.orElse(null) : null;
    }

    @Override
    @Nullable
    public SPSession addSPSession(@Nonnull SPSession spSession) throws SessionException {
        return this.doAddSPSession(spSession);
    }

    @Override
    public boolean removeSPSession(@Nonnull SPSession spSession) throws SessionException {
        return this.doRemoveSPSession(spSession);
    }

    @Nullable
    public SPSession doAddSPSession(@Nonnull SPSession spSession) {
        Constraint.isNotNull((Object)spSession, (String)"SPSession cannot be null");
        Optional<SPSession> prev = this.spSessions.put(spSession.getId(), Optional.of(spSession));
        if (prev != null && prev.isPresent()) {
            this.log.debug("IdPSession {}: replaced old SPSession for service {}", (Object)this.id, (Object)prev.get().getId());
            return prev.get();
        }
        return null;
    }

    public boolean doRemoveSPSession(@Nonnull SPSession spSession) {
        Constraint.isNotNull((Object)spSession, (String)"SPSession cannot be null");
        if (this.spSessions.remove(spSession.getId(), Optional.of(spSession))) {
            return true;
        }
        return this.spSessions.remove(spSession.getId(), Optional.empty());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractIdPSession) {
            return Objects.equals(this.getId(), ((AbstractIdPSession)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sessionId", (Object)this.id).add("principalName", (Object)this.principalName).add("IPv4", (Object)this.ipV4Address).add("IPv6", (Object)this.ipV6Address).add("Unk", (Object)this.unknownAddress).add("creationInstant", (Object)this.creationInstant).add("lastActivityInstant", (Object)this.lastActivityInstant).add("authenticationResults", this.getAuthenticationResults()).add("spSessions", this.getSPSessions()).toString();
    }

    @Nonnull
    @Live
    protected Map<String, Optional<AuthenticationResult>> getAuthenticationResultMap() {
        return this.authenticationResults;
    }

    @Nonnull
    @Live
    protected Map<String, Optional<SPSession>> getSPSessionMap() {
        return this.spSessions;
    }

    @Nonnull
    protected static AddressFamily getAddressFamily(@Nonnull @NotEmpty String address) {
        if (address.contains(":")) {
            return AddressFamily.IPV6;
        }
        if (address.contains(".")) {
            return AddressFamily.IPV4;
        }
        return AddressFamily.UNKNOWN;
    }

    public static enum AddressFamily {
        IPV4,
        IPV6,
        UNKNOWN;

    }
}

