/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;

@ThreadSafe
public abstract class AbstractSPSessionSerializer
extends AbstractInitializableComponent
implements StorageSerializer<SPSession> {
    @Nonnull
    @NotEmpty
    private static final String SERVICE_ID_FIELD = "id";
    @Nonnull
    @NotEmpty
    private static final String CREATION_INSTANT_FIELD = "ts";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSPSessionSerializer.class);
    @Nonnull
    private final Duration expirationOffset;

    protected AbstractSPSessionSerializer(@Nonnull Duration offset) {
        this.expirationOffset = (Duration)Constraint.isNotNull((Object)offset, (String)"Offset cannot be null");
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull SPSession instance) throws IOException {
        try {
            StringWriter sink = new StringWriter(128);
            JsonGenerator gen = Json.createGenerator((Writer)sink);
            gen.writeStartObject().write(SERVICE_ID_FIELD, instance.getId()).write(CREATION_INSTANT_FIELD, instance.getCreationInstant().toEpochMilli());
            this.doSerializeAdditional(instance, gen);
            gen.writeEnd().close();
            return sink.toString();
        }
        catch (JsonException e) {
            this.log.error("Exception while serializing SPSession: {}", (Object)e.getMessage());
            throw new IOException("Exception while serializing SPSession", e);
        }
    }

    @Nonnull
    public SPSession deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        if (expiration == null) {
            throw new IOException("SPSession objects must have an expiration");
        }
        try {
            JsonReader reader = Json.createReader((Reader)new StringReader(value));
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing SPSession");
            }
            JsonObject obj = (JsonObject)st;
            String serviceId = obj.getString(SERVICE_ID_FIELD);
            Instant creation = Instant.ofEpochMilli(obj.getJsonNumber(CREATION_INSTANT_FIELD).longValueExact());
            assert (serviceId != null);
            assert (creation != null);
            return this.doDeserialize(obj, serviceId, creation, Instant.ofEpochMilli(expiration).minus(this.expirationOffset));
        }
        catch (JsonException | ArithmeticException | ClassCastException | NullPointerException e) {
            this.log.error("Exception while parsing SPSession: {}", (Object)e.getMessage());
            throw new IOException("Found invalid data structure while parsing SPSession", e);
        }
    }

    protected void doSerializeAdditional(@Nonnull SPSession instance, @Nonnull JsonGenerator generator) {
    }

    @Nonnull
    protected abstract SPSession doDeserialize(@Nonnull JsonObject var1, @Nonnull @NotEmpty String var2, @Nonnull Instant var3, @Nonnull Instant var4) throws IOException;
}

