/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.logic;

import com.google.common.net.InetAddresses;
import java.util.Collection;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.IPRange;

public class IPRangeBiPredicate
implements BiPredicate<String, String> {
    @Nonnull
    private Collection<IPRange> addressRanges = CollectionSupport.emptyList();

    IPRangeBiPredicate() {
    }

    public void setRanges(@Nonnull Collection<IPRange> ranges) {
        Constraint.isNotNull(ranges, (String)"Address range collection cannot be null");
        this.addressRanges = CollectionSupport.copyToList(ranges);
    }

    @Override
    public boolean test(@Nullable String input1, @Nullable String input2) {
        if (input1 == null || input2 == null) {
            return false;
        }
        if (input1.equals(input2)) {
            return true;
        }
        for (IPRange range : this.addressRanges) {
            if (!range.contains(InetAddresses.forString((String)input1)) || !range.contains(InetAddresses.forString((String)input2))) continue;
            return true;
        }
        return false;
    }
}

