/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Predicates;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestroySessions
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DestroySessions.class);
    @NonnullAfterInit
    private SessionManager sessionManager;
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextLookupStrategy = new ChildContextLookup(SessionContext.class);
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextLookupStrategy = new ChildContextLookup(LogoutContext.class);
    @Nullable
    private SessionContext sessionContext;
    @Nullable
    private LogoutContext logoutContext;

    public void setSessionManager(@Nonnull SessionManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionManager = (SessionManager)Constraint.isNotNull((Object)manager, (String)"SessionManager cannot be null");
    }

    public void setSessionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext lookup strategy cannot be null");
    }

    public void setLogoutContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.logoutContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.getActivationCondition().equals(Predicates.alwaysFalse()) && this.sessionManager == null) {
            throw new ComponentInitializationException("SessionManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.logoutContext = this.logoutContextLookupStrategy.apply(profileRequestContext);
        if (this.logoutContext == null || this.logoutContext.getIdPSessions().isEmpty()) {
            this.log.debug("{} No LogoutContext or IdPSessions found, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.sessionContext = this.sessionContextLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        for (IdPSession session : this.logoutContext.getIdPSessions()) {
            boolean unbind;
            this.log.debug("{} Attempting destruction of session {}", (Object)this.getLogPrefix(), (Object)session.getId());
            boolean bl = unbind = this.sessionContext != null && this.sessionContext.getIdPSession() != null ? this.sessionContext.getIdPSession().equals(session) : false;
            if (unbind) {
                this.sessionContext.getParent().removeSubcontext((BaseContext)this.sessionContext);
                this.sessionContext = null;
            }
            try {
                this.sessionManager.destroySession(session.getId(), unbind);
            }
            catch (SessionException e) {
                this.log.error("{} Error destroying session", (Object)this.getLogPrefix(), (Object)e);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
        this.logoutContext.getIdPSessions().clear();
    }
}

