/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class LogoutStatusStrategyFunction
implements Function<ProfileRequestContext, List<String>> {
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextLookupStrategy = new ChildContextLookup(LogoutContext.class);

    public void setLogoutContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        this.logoutContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable ProfileRequestContext input) {
        LogoutContext logoutCtx = this.logoutContextLookupStrategy.apply(input);
        if (logoutCtx != null && !logoutCtx.getIdPSessions().isEmpty()) {
            return Arrays.asList("urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied");
        }
        return Collections.emptyList();
    }
}

