/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.context.AuditContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreProfileRequestContextTree
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RestoreProfileRequestContextTree.class);
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextLookupStrategy = new ChildContextLookup(LogoutContext.class);

    public void setLogoutContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        this.logoutContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AuditContext auditCtx;
        LogoutContext logoutContext = this.logoutContextLookupStrategy.apply(profileRequestContext);
        if (logoutContext == null) {
            this.log.debug("{} LogoutContext not found in ProfileRequestContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((Object)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        InOutOperationContext placeholder = (InOutOperationContext)logoutContext.getSubcontext(InOutOperationContext.class);
        if (placeholder == null) {
            this.log.debug("{} InOutOperationContext not found under LogoutContext, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        logoutContext.removeSubcontext((BaseContext)placeholder);
        profileRequestContext.setInboundMessageContext(placeholder.getInboundMessageContext());
        profileRequestContext.setOutboundMessageContext(placeholder.getOutboundMessageContext());
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)placeholder.getSubcontext(RelyingPartyContext.class);
        if (relyingPartyCtx != null) {
            profileRequestContext.addSubcontext((BaseContext)relyingPartyCtx, true);
        }
        if ((auditCtx = (AuditContext)placeholder.getSubcontext(AuditContext.class)) != null) {
            profileRequestContext.addSubcontext((BaseContext)auditCtx, true);
        }
        this.log.debug("{} Restored LogoutRequest processing state after logout propagation", (Object)this.getLogPrefix());
    }
}

