/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.LogoutPropagationFlowDescriptor;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectLogoutPropagationFlow
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectLogoutPropagationFlow.class);
    @Nonnull
    private final Function<SPSession, LogoutPropagationFlowDescriptor> flowSelectorFunction;
    @Nonnull
    private Function<ProfileRequestContext, LogoutPropagationContext> logoutPropagationContextFunction;

    public SelectLogoutPropagationFlow(@Nonnull Function<SPSession, LogoutPropagationFlowDescriptor> selector) {
        this.flowSelectorFunction = (Function)Constraint.isNotNull(selector, (String)"Selector cannot be null");
        this.logoutPropagationContextFunction = new ChildContextLookup(LogoutPropagationContext.class);
    }

    public void setLogoutPropagationContextFunction(@Nonnull Function<ProfileRequestContext, LogoutPropagationContext> function) {
        this.logoutPropagationContextFunction = (Function)Constraint.isNotNull(function, (String)"Function cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        LogoutPropagationContext logoutPropCtx = this.logoutPropagationContextFunction.apply(profileRequestContext);
        if (logoutPropCtx == null || logoutPropCtx.getSession() == null) {
            this.log.error("{} LogoutPropagationContext not found or found with null SPSession", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoPotentialFlow");
            return;
        }
        LogoutPropagationFlowDescriptor flow = this.flowSelectorFunction.apply(logoutPropCtx.getSession());
        if (flow == null) {
            this.log.error("{} No potential flows to choose from, no logout propagation possible", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoPotentialFlow");
            return;
        }
        this.log.debug("{} Selecting logout propagation flow {}", (Object)this.getLogPrefix(), (Object)flow.getId());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)flow.getId());
    }
}

