/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.session.AbstractIdPSession;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.impl.StorageBackedIdPSessionSerializer;
import net.shibboleth.idp.session.impl.StorageBackedSessionManager;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.commons.codec.digest.DigestUtils;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageBackedIdPSession
extends AbstractIdPSession {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageBackedIdPSession.class);
    @Nonnull
    private final StorageBackedSessionManager sessionManager;
    private long version;

    public StorageBackedIdPSession(@Nonnull StorageBackedSessionManager manager, @Nonnull @NotEmpty String sessionId, @Nonnull @NotEmpty String canonicalName, @Nonnull Instant creationTime) {
        super(sessionId, canonicalName, creationTime);
        this.sessionManager = (StorageBackedSessionManager)((Object)Constraint.isNotNull((Object)((Object)manager), (String)"SessionManager cannot be null"));
        this.version = 1L;
    }

    public void setLastActivityInstant(@Nonnull Instant instant) throws SessionException {
        Instant exp = instant.plus(this.sessionManager.getSessionTimeout()).plus(this.sessionManager.getSessionSlop());
        this.log.debug("Updating expiration of primary record for session {} to {}", (Object)this.getId(), (Object)exp);
        try {
            this.sessionManager.getStorageService().updateExpiration(this.getId(), "_session", Long.valueOf(exp.toEpochMilli()));
            super.setLastActivityInstant(instant);
        }
        catch (IOException e) {
            if (!this.sessionManager.isMaskStorageFailure()) {
                throw new SessionException("Exception updating expiration of session record", (Exception)e);
            }
            this.log.error("Exception updating expiration of primary record for session {}", (Object)this.getId(), (Object)e);
        }
    }

    public boolean checkAddress(@Nonnull @NotEmpty String address) throws SessionException {
        AbstractIdPSession.AddressFamily family = StorageBackedIdPSession.getAddressFamily((String)address);
        String bound = this.getAddress(family);
        if (bound != null) {
            if (!this.sessionManager.getConsistentAddressCondition().test(bound, address)) {
                this.log.warn("Client address {} invalid for session {} bound to {}", new Object[]{address, this.getId(), bound});
                return false;
            }
        } else {
            this.log.info("Session {} not yet bound to {} address, binding to {}", new Object[]{this.getId(), family, address});
            try {
                this.bindToAddress(address);
            }
            catch (SessionException e) {
                this.log.error("Unable to bind session {} to address {}", (Object)this.getId(), (Object)address);
                return false;
            }
        }
        return true;
    }

    public void bindToAddress(@Nonnull @NotEmpty String address) throws SessionException {
        super.bindToAddress(address);
        try {
            int attempts = 10;
            boolean success = this.writeToStorage();
            while (!success && attempts-- > 0) {
                String nowBound = this.getAddress(StorageBackedIdPSession.getAddressFamily((String)address));
                if (nowBound != null) {
                    if (nowBound.equals(address)) {
                        return;
                    }
                    this.log.warn("Client address is {} but session {} already bound to {}", new Object[]{address, this.getId(), nowBound});
                    throw new SessionException("A different address of the same type was bound to the session");
                }
                super.bindToAddress(address);
                success = this.writeToStorage();
            }
            if (!success) {
                this.log.error("Exhausted retry attempts updating record for session {}", (Object)this.getId());
            }
        }
        catch (IOException e) {
            if (!this.sessionManager.isMaskStorageFailure()) {
                throw new SessionException("Exception updating address binding of session record", (Exception)e);
            }
            this.log.error("Exception updating address binding of primary record for session {}", (Object)this.getId(), (Object)e);
        }
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<AuthenticationResult> getAuthenticationResults() {
        Iterator<Map.Entry<String, Optional<AuthenticationResult>>> entries = this.getAuthenticationResultMap().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, Optional<AuthenticationResult>> entry = entries.next();
            if (!entry.getValue().isEmpty()) continue;
            try {
                AuthenticationResult result = this.loadAuthenticationResultFromStorage(entry.getKey());
                if (result != null) {
                    entry.setValue(Optional.of(result));
                    continue;
                }
                entries.remove();
            }
            catch (IOException iOException) {}
        }
        return super.getAuthenticationResults();
    }

    @Nullable
    public AuthenticationResult getAuthenticationResult(@Nonnull @NotEmpty String flowId) {
        AuthenticationResult result = super.getAuthenticationResult(flowId);
        if (result != null) {
            return result;
        }
        String trimmed = StringSupport.trimOrNull((String)flowId);
        if (!this.getAuthenticationResultMap().containsKey(trimmed)) {
            return null;
        }
        try {
            result = this.loadAuthenticationResultFromStorage(trimmed);
            if (result != null) {
                this.doAddAuthenticationResult(result);
            } else {
                this.getAuthenticationResultMap().remove(trimmed);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Nullable
    public AuthenticationResult addAuthenticationResult(@Nonnull AuthenticationResult result) throws SessionException {
        try {
            if (!this.saveAuthenticationResultToStorage(result) && !this.sessionManager.isMaskStorageFailure()) {
                throw new SessionException("Unable to save AuthenticationResult to storage");
            }
            AuthenticationResult prev = super.addAuthenticationResult(result);
            if (prev == null) {
                int attempts = 10;
                boolean success = this.writeToStorage();
                while (!success && attempts-- > 0) {
                    if (!this.getAuthenticationResultMap().containsKey(result.getAuthenticationFlowId())) {
                        super.addAuthenticationResult(result);
                        success = this.writeToStorage();
                        continue;
                    }
                    success = true;
                }
                if (!success) {
                    this.log.error("Exhausted retry attempts updating record for session {}", (Object)this.getId());
                }
            }
            return prev;
        }
        catch (IOException e) {
            if (!this.sessionManager.isMaskStorageFailure()) {
                throw new SessionException("Exception saving AuthenticationResult record to storage", (Exception)e);
            }
            this.log.error("Exception saving AuthenticationResult record for session {} and flow {}", new Object[]{this.getId(), result.getAuthenticationFlowId(), e});
            return null;
        }
    }

    public void updateAuthenticationResultActivity(@Nonnull AuthenticationResult result) throws SessionException {
        String flowId = result.getAuthenticationFlowId();
        AuthenticationFlowDescriptor flow = this.sessionManager.getAuthenticationFlowDescriptor(flowId);
        if (flow != null) {
            try {
                if (!this.sessionManager.getStorageService().updateExpiration(this.getId(), result.getAuthenticationFlowId(), Long.valueOf(result.getLastActivityInstant().plus(flow.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()))) {
                    this.log.warn("Skipping update, AuthenticationResult for flow {} in session {} not found in storage", (Object)flowId, (Object)this.getId());
                }
            }
            catch (IOException e) {
                if (!this.sessionManager.isMaskStorageFailure()) {
                    throw new SessionException("Exception updating AuthenticationResult expiration in storage", (Exception)e);
                }
                this.log.error("Exception updating AuthenticationResult expiration for session {} and flow {}", new Object[]{this.getId(), flowId, e});
            }
        } else {
            this.log.warn("No flow descriptor installed for ID {}, unable to update result in storage", (Object)flowId);
        }
    }

    public boolean removeAuthenticationResult(@Nonnull AuthenticationResult result) throws SessionException {
        if (super.removeAuthenticationResult(result)) {
            try {
                this.sessionManager.getStorageService().delete(this.getId(), result.getAuthenticationFlowId());
            }
            catch (IOException e) {
                if (!this.sessionManager.isMaskStorageFailure()) {
                    throw new SessionException("Exception removing AuthenticationResult record from storage", (Exception)e);
                }
                this.log.error("Exception removing AuthenticationResult record for session {} and flow {}", new Object[]{this.getId(), result.getAuthenticationFlowId(), e});
            }
            try {
                int attempts = 10;
                boolean success = this.writeToStorage();
                while (!success && attempts-- > 0) {
                    if (super.removeAuthenticationResult(result)) {
                        success = this.writeToStorage();
                        continue;
                    }
                    return true;
                }
                if (!success) {
                    this.log.error("Exhausted retry attempts updating record for session {}", (Object)this.getId());
                }
            }
            catch (IOException e) {
                if (!this.sessionManager.isMaskStorageFailure()) {
                    throw new SessionException("Exception updating session record after AuthenticationResult removal", (Exception)e);
                }
                this.log.error("Exception updating record for session {}", (Object)this.getId(), (Object)e);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<SPSession> getSPSessions() {
        if (this.sessionManager.isTrackSPSessions() && this.sessionManager.storageServiceMeetsThreshold()) {
            Iterator<Map.Entry<String, Optional<SPSession>>> entries = this.getSPSessionMap().entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, Optional<SPSession>> entry = entries.next();
                if (!entry.getValue().isEmpty()) continue;
                try {
                    SPSession result = this.loadSPSessionFromStorage(entry.getKey());
                    if (result != null) {
                        entry.setValue(Optional.of(result));
                        continue;
                    }
                    entries.remove();
                }
                catch (IOException iOException) {}
            }
        }
        return super.getSPSessions();
    }

    @Nullable
    public SPSession getSPSession(@Nonnull @NotEmpty String serviceId) {
        if (this.sessionManager.isTrackSPSessions() && this.sessionManager.storageServiceMeetsThreshold()) {
            SPSession result = super.getSPSession(serviceId);
            if (result != null) {
                return result;
            }
            String trimmed = StringSupport.trimOrNull((String)serviceId);
            if (!this.getSPSessionMap().containsKey(trimmed)) {
                return null;
            }
            try {
                result = this.loadSPSessionFromStorage(trimmed);
                if (result != null) {
                    this.doAddSPSession(result);
                } else {
                    this.getSPSessionMap().remove(trimmed);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }
        return null;
    }

    @Nullable
    public SPSession addSPSession(@Nonnull SPSession spSession) throws SessionException {
        if (this.sessionManager.isTrackSPSessions()) {
            if (!this.sessionManager.storageServiceMeetsThreshold()) {
                this.log.debug("Unable to add SP session due to to storage service limitations");
                return null;
            }
            try {
                this.getSPSession(spSession.getId());
                if (!this.saveSPSessionToStorage(spSession) && !this.sessionManager.isMaskStorageFailure()) {
                    throw new SessionException("Unable to save SPSession to storage");
                }
                SPSession prev = super.addSPSession(spSession);
                if (prev == null) {
                    int attempts = 10;
                    boolean success = this.writeToStorage();
                    while (!success && attempts-- > 0) {
                        if (!this.getSPSessionMap().containsKey(spSession.getId())) {
                            super.addSPSession(spSession);
                            success = this.writeToStorage();
                            continue;
                        }
                        success = true;
                    }
                    if (!success) {
                        this.log.error("Exhausted retry attempts updating record for session {}", (Object)this.getId());
                    }
                } else {
                    this.sessionManager.unindexSPSession((IdPSession)this, prev, 10);
                }
                this.sessionManager.indexBySPSession((IdPSession)this, spSession, 10);
                return prev;
            }
            catch (IOException e) {
                if (!this.sessionManager.isMaskStorageFailure()) {
                    throw new SessionException("Exception saving SPSession record to storage", (Exception)e);
                }
                this.log.error("Exception saving SPSession record for IdP session {} and service {}", new Object[]{this.getId(), spSession.getId(), e});
                return null;
            }
        }
        this.log.debug("Ignoring SPSession add, session manager is not configured to track them");
        return null;
    }

    public boolean removeSPSession(@Nonnull SPSession spSession) throws SessionException {
        if (super.removeSPSession(spSession)) {
            block9: {
                try {
                    this.sessionManager.getStorageService().delete(this.getId(), this.getSPSessionStorageKey(spSession.getId()));
                }
                catch (IOException e) {
                    this.log.error("Exception removing SPSession record for IdP session {} and service {}", new Object[]{this.getId(), spSession.getId(), e});
                    if (this.sessionManager.isMaskStorageFailure()) break block9;
                    throw new SessionException("Exception removing SPSession record from storage", (Exception)e);
                }
            }
            try {
                int attempts = 10;
                boolean success = this.writeToStorage();
                while (!success && attempts-- > 0) {
                    if (super.removeSPSession(spSession)) {
                        success = this.writeToStorage();
                        continue;
                    }
                    return true;
                }
                if (!success) {
                    this.log.error("Exhausted retry attempts updating record for session {}", (Object)this.getId());
                }
            }
            catch (IOException e) {
                if (!this.sessionManager.isMaskStorageFailure()) {
                    throw new SessionException("Exception updating session record after SPSession removal", (Exception)e);
                }
                this.log.error("Exception updating record for session {}", (Object)this.getId(), (Object)e);
            }
            return true;
        }
        return false;
    }

    public boolean checkTimeout() throws SessionException {
        if (this.getLastActivityInstant().plus(this.sessionManager.getSessionTimeout()).isAfter(Instant.now())) {
            return super.checkTimeout();
        }
        return false;
    }

    protected long getVersion() {
        return this.version;
    }

    protected void setVersion(long ver) {
        this.version = ver;
    }

    @Nonnull
    @NonnullElements
    @Live
    protected Map<String, Optional<AuthenticationResult>> getAuthenticationResultMap() {
        return super.getAuthenticationResultMap();
    }

    @Nonnull
    @NonnullElements
    @Live
    protected Map<String, Optional<SPSession>> getSPSessionMap() {
        return super.getSPSessionMap();
    }

    @Nullable
    private AuthenticationResult loadAuthenticationResultFromStorage(@Nonnull @NotEmpty String flowId) throws IOException {
        this.log.debug("Loading AuthenticationResult for flow {} in session {}", (Object)flowId, (Object)this.getId());
        AuthenticationFlowDescriptor flow = this.sessionManager.getAuthenticationFlowDescriptor(flowId);
        if (flow == null) {
            this.log.warn("No flow descriptor installed for ID {}, unable to load result from storage", (Object)flowId);
            return null;
        }
        try {
            StorageRecord record = this.sessionManager.getStorageService().read(this.getId(), flowId);
            if (record != null) {
                return (AuthenticationResult)record.getValue((StorageSerializer)flow, this.getId(), flowId);
            }
            this.log.debug("No AuthenticationResult for flow {} in session {}", (Object)flowId, (Object)this.getId());
            return null;
        }
        catch (IOException e) {
            this.log.error("Exception loading AuthenticationResult for flow {} from storage: {}", (Object)flowId, (Object)e.getMessage());
            throw e;
        }
    }

    private boolean saveAuthenticationResultToStorage(@Nonnull AuthenticationResult result) throws IOException {
        String flowId = result.getAuthenticationFlowId();
        this.log.debug("Saving AuthenticationResult for flow {} in session {}", (Object)flowId, (Object)this.getId());
        AuthenticationFlowDescriptor flow = this.sessionManager.getAuthenticationFlowDescriptor(flowId);
        if (flow == null) {
            this.log.warn("No flow descriptor installed for ID {}, unable to save result to storage", (Object)flowId);
            return false;
        }
        try {
            int attempts = 10;
            boolean success = false;
            do {
                if (success = this.sessionManager.getStorageService().create(this.getId(), flowId, (Object)result, (StorageSerializer)flow, Long.valueOf(result.getLastActivityInstant().plus(flow.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()))) continue;
                success = this.sessionManager.getStorageService().update(this.getId(), flowId, (Object)result, (StorageSerializer)flow, Long.valueOf(result.getLastActivityInstant().plus(flow.getInactivityTimeout()).plus(AuthenticationFlowDescriptor.STORAGE_EXPIRATION_OFFSET).toEpochMilli()));
            } while (!success && attempts-- > 0);
            if (!success) {
                this.log.error("Exhausted retry attempts storing AuthenticationResult for flow {} in session {}", (Object)flowId, (Object)this.getId());
            }
            return success;
        }
        catch (IOException e) {
            this.log.error("Exception saving AuthenticationResult for flow {} to storage: {}", (Object)flowId, (Object)e.getMessage());
            throw e;
        }
    }

    @Nullable
    private SPSession loadSPSessionFromStorage(@Nonnull @NotEmpty String serviceId) throws IOException {
        this.log.debug("Loading SPSession for service {} in session {}", (Object)serviceId, (Object)this.getId());
        String key = this.getSPSessionStorageKey(serviceId);
        try {
            StorageRecord record = this.sessionManager.getStorageService().read(this.getId(), key);
            if (record == null) {
                this.log.debug("No SPSession found for service {} in session {}", (Object)serviceId, (Object)this.getId());
                return null;
            }
            int pos = record.getValue().indexOf(58);
            if (pos <= 0) {
                throw new IOException("No class type found prefixed to record");
            }
            String sessionClassName = record.getValue().substring(0, pos);
            StorageSerializer spSessionSerializer = this.sessionManager.getSPSessionSerializerRegistry().lookup(Class.forName(sessionClassName).asSubclass(SPSession.class));
            if (spSessionSerializer == null) {
                throw new IOException("No serializer registered for SPSession type " + sessionClassName);
            }
            return (SPSession)spSessionSerializer.deserialize(record.getVersion(), this.getId(), key, record.getValue().substring(pos + 1), record.getExpiration());
        }
        catch (IOException e) {
            this.log.error("IOException loading SPSession for service {} from storage: {}", (Object)serviceId, (Object)e.getMessage());
            throw e;
        }
        catch (ClassNotFoundException e) {
            this.log.error("ClassNotFoundException loading SPSession for service {} from storage: {}", (Object)serviceId, (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    private boolean saveSPSessionToStorage(@Nonnull SPSession session) throws IOException {
        this.log.debug("Saving SPSession for service {} in session {}", (Object)session.getId(), (Object)this.getId());
        StorageSerializer spSessionSerializer = this.sessionManager.getSPSessionSerializerRegistry().lookup(session.getClass());
        if (spSessionSerializer == null) {
            throw new IOException("No serializer registered for SPSession type " + session.getClass().getName());
        }
        String key = this.getSPSessionStorageKey(session.getId());
        StringBuilder builder = new StringBuilder(session.getClass().getName());
        builder.append(':').append(spSessionSerializer.serialize((Object)session));
        try {
            int attempts = 10;
            boolean success = false;
            do {
                Instant exp = session.getExpirationInstant().plus(this.sessionManager.getSessionSlop());
                success = this.sessionManager.getStorageService().create(this.getId(), key, builder.toString(), Long.valueOf(exp.toEpochMilli()));
                if (success) continue;
                success = this.sessionManager.getStorageService().update(this.getId(), key, builder.toString(), Long.valueOf(exp.toEpochMilli()));
            } while (!success && attempts-- > 0);
            if (!success) {
                this.log.error("Exhausted retry attempts storing SPService for service {} in session {}", (Object)session.getId(), (Object)this.getId());
            }
            return success;
        }
        catch (IOException e) {
            this.log.error("IOException saving SPSession for service {} to storage: {}", (Object)session.getId(), (Object)e.getMessage());
            throw e;
        }
    }

    @Nonnull
    @NotEmpty
    private String getSPSessionStorageKey(@Nonnull @NotEmpty String serviceId) {
        if (serviceId.length() > this.sessionManager.getStorageService().getCapabilities().getKeySize()) {
            return DigestUtils.sha256Hex((String)serviceId);
        }
        return serviceId;
    }

    private boolean writeToStorage() throws IOException {
        try {
            Instant exp = this.getLastActivityInstant().plus(this.sessionManager.getSessionTimeout()).plus(this.sessionManager.getSessionSlop());
            Long ver = this.sessionManager.getStorageService().updateWithVersion(this.version, this.getId(), "_session", (Object)this, this.sessionManager.getStorageSerializer(), Long.valueOf(exp.toEpochMilli()));
            if (ver == null) {
                this.log.error("Record for session {} has disappeared from backing store", (Object)this.getId());
                throw new IOException("Unable to update session, record disappeared");
            }
            this.version = ver;
            return true;
        }
        catch (VersionMismatchException e) {
            StorageRecord record = this.sessionManager.getStorageService().read(this.getId(), "_session");
            if (record == null) {
                this.log.error("Record for session {} has disappeared from backing store", (Object)this.getId());
                throw new IOException("Unable to update session, record disappeared");
            }
            record.getValue((StorageSerializer)new StorageBackedIdPSessionSerializer(this.sessionManager, this), this.getId(), "_session");
            return false;
        }
    }
}

