/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Predicates;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSessionWithAuthenticationResult
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UpdateSessionWithAuthenticationResult.class);
    @NonnullAfterInit
    private SessionManager sessionManager;
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextCreationStrategy = new ChildContextLookup(SessionContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextLookupStrategy = new ChildContextLookup(SubjectContext.class);
    @Nullable
    private SessionContext sessionCtx;
    @Nullable
    private SubjectContext subjectCtx;

    public void setSessionManager(@Nonnull SessionManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionManager = (SessionManager)Constraint.isNotNull((Object)manager, (String)"SessionManager cannot be null");
    }

    public void setSessionContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext lookup/creation strategy cannot be null");
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.subjectContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.getActivationCondition().equals(Predicates.alwaysFalse()) && this.sessionManager == null) {
            throw new ComponentInitializationException("SessionManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (super.doPreExecute(profileRequestContext, authenticationContext) && authenticationContext.getAuthenticationResult() != null) {
            this.subjectCtx = this.subjectContextLookupStrategy.apply(profileRequestContext);
            this.sessionCtx = this.sessionContextCreationStrategy.apply(profileRequestContext);
            if (this.sessionCtx == null) {
                this.log.error("{} SessionContext creation failed", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return false;
            }
            return this.sessionCtx.getIdPSession() != null || this.subjectCtx != null && this.subjectCtx.getPrincipalName() != null;
        }
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        IdPSession session = this.sessionCtx.getIdPSession();
        if (session != null) {
            try {
                this.updateIdPSession(authenticationContext, session);
            }
            catch (SessionException e) {
                this.log.error("{} Error updating session {}", new Object[]{this.getLogPrefix(), session.getId(), e});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        } else {
            try {
                this.createIdPSession(authenticationContext);
            }
            catch (SessionException e) {
                this.log.error("{} Error creating session for principal {}", new Object[]{this.getLogPrefix(), this.subjectCtx.getPrincipalName(), e});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
    }

    private void updateIdPSession(@Nonnull AuthenticationContext authenticationContext, @Nonnull IdPSession session) throws SessionException {
        if (authenticationContext.getAttemptedFlow() != null) {
            if (authenticationContext.isResultCacheable()) {
                this.log.debug("{} Adding new AuthenticationResult for flow {} to existing session {}", new Object[]{this.getLogPrefix(), authenticationContext.getAuthenticationResult().getAuthenticationFlowId(), session.getId()});
                session.addAuthenticationResult(authenticationContext.getAuthenticationResult());
            }
        } else {
            this.log.debug("{} Updating activity time on reused AuthenticationResult for flow {} in existing session {}", new Object[]{this.getLogPrefix(), authenticationContext.getAuthenticationResult().getAuthenticationFlowId(), session.getId()});
            session.updateAuthenticationResultActivity(authenticationContext.getAuthenticationResult());
        }
    }

    private void createIdPSession(@Nonnull AuthenticationContext authenticationContext) throws SessionException {
        this.log.debug("{} Creating new session for principal {}", (Object)this.getLogPrefix(), (Object)this.subjectCtx.getPrincipalName());
        this.sessionCtx.setIdPSession(this.sessionManager.createSession(this.subjectCtx.getPrincipalName()));
        if (authenticationContext.isResultCacheable()) {
            this.sessionCtx.getIdPSession().addAuthenticationResult(authenticationContext.getAuthenticationResult());
        }
    }
}

