/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Predicates;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSessionWithSPSession
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UpdateSessionWithSPSession.class);
    @Nonnull
    private Function<ProfileRequestContext, SPSession> spSessionCreationStrategy;
    @NonnullAfterInit
    private SessionManager sessionManager;
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextLookupStrategy = new ChildContextLookup(SessionContext.class);
    @Nullable
    private SessionContext sessionCtx;

    public void setSPSessionCreationStrategy(@Nonnull Function<ProfileRequestContext, SPSession> strategy) {
        this.spSessionCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SPSession creation strategy function cannot be null");
    }

    public void setSessionManager(@Nonnull SessionManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionManager = (SessionManager)Constraint.isNotNull((Object)manager, (String)"SessionManager cannot be null");
    }

    public void setSessionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.getActivationCondition().equals(Predicates.alwaysFalse())) {
            if (this.sessionManager == null) {
                throw new ComponentInitializationException("SessionManager cannot be null");
            }
            if (this.spSessionCreationStrategy == null) {
                throw new ComponentInitializationException("Session creation strategy cannot be null");
            }
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (super.doPreExecute(profileRequestContext)) {
            this.sessionCtx = this.sessionContextLookupStrategy.apply(profileRequestContext);
            return this.sessionCtx != null && this.sessionCtx.getIdPSession() != null;
        }
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SPSession spSession = this.spSessionCreationStrategy.apply(profileRequestContext);
        if (spSession == null) {
            this.log.debug("{} SPSession was not returned, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        IdPSession idpSession = this.sessionCtx.getIdPSession();
        try {
            this.log.debug("{} Adding new SPSession for relying party {} to existing session {}", new Object[]{this.getLogPrefix(), spSession.getId(), idpSession.getId()});
            SPSession old = idpSession.addSPSession(spSession);
            if (old != null) {
                this.log.debug("{} Older SPSession for relying party {} was replaced", (Object)this.getLogPrefix(), (Object)old.getId());
            }
        }
        catch (SessionException e) {
            this.log.error("{} Error updating session {}", new Object[]{this.getLogPrefix(), idpSession.getId(), e});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }
}

