/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.testing;

import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.profile.config.AbstractInterceptorAwareProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.xmlsec.config.BasicXMLSecurityConfiguration;

public class MockAuthenticationProfileConfiguration
extends AbstractInterceptorAwareProfileConfiguration
implements AuthenticationProfileConfiguration {
    @Nonnull
    private List<Principal> defaultAuthenticationMethods = CollectionSupport.emptyList();
    @Nonnull
    private Set<String> authenticationFlows = CollectionSupport.emptySet();
    @Nonnull
    private List<String> postAuthenticationFlows = CollectionSupport.emptyList();
    @Nonnull
    private List<String> nameIDFormatPrecedence = CollectionSupport.emptyList();
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate;
    private Integer proxyCount;

    public MockAuthenticationProfileConfiguration(@Nonnull @NotEmpty String id, @Nonnull List<Principal> methods) {
        this(id, methods, CollectionSupport.emptySet(), CollectionSupport.emptyList());
    }

    public MockAuthenticationProfileConfiguration(@Nonnull @NotEmpty String id, @Nonnull List<Principal> methods, @Nonnull Collection<String> flows, @Nonnull List<String> formats) {
        super(id);
        this.setSecurityConfiguration((SecurityConfiguration)new BasicXMLSecurityConfiguration());
        this.setDefaultAuthenticationMethods(methods);
        this.setAuthenticationFlows(flows);
        this.setNameIDFormatPrecedence(formats);
        this.forceAuthnPredicate = PredicateSupport.alwaysFalse();
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        return this.defaultAuthenticationMethods;
    }

    public void setDefaultAuthenticationMethods(@Nonnull List<Principal> methods) {
        this.defaultAuthenticationMethods = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(methods, (String)"List of methods cannot be null")));
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence(@Nullable ProfileRequestContext profileRequestContext) {
        return this.nameIDFormatPrecedence;
    }

    public void setNameIDFormatPrecedence(@Nonnull List<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedence = CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(formats));
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        return this.authenticationFlows;
    }

    public void setAuthenticationFlows(@Nonnull Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.authenticationFlows = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(flows));
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        return this.postAuthenticationFlows;
    }

    public void setPostAuthenticationFlows(@Nonnull Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.postAuthenticationFlows = CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(flows));
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    @Nullable
    @NonNegative
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        return this.proxyCount;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        this.proxyCount = count != null ? Integer.valueOf(Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count cannot be negative")) : null;
    }
}

