/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.testing;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.testing.MockProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.BasicRelyingPartyConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

public class RequestContextBuilder {
    @Nonnull
    @NotEmpty
    private static final String NO_VAL = "novalue";
    @Nullable
    private ServletContext servletContext;
    @Nullable
    private HttpServletRequest httpRequest;
    @Nullable
    private HttpServletResponse httpResponse;
    @Nullable
    private String inboundMessageId = "novalue";
    @Nullable
    private Instant inboundMessageIssueInstant;
    @Nullable
    private String inboundMessageIssuer = "novalue";
    @Nullable
    private Object inboundMessage;
    @Nullable
    private String outboundMessageId = "novalue";
    @Nullable
    private Instant outboundMessageIssueInstant;
    @Nullable
    private String outboundMessageIssuer = "novalue";
    @Nullable
    private Object outboundMessage;
    @Nullable
    private Collection<ProfileConfiguration> relyingPartyProfileConfigurations;

    public RequestContextBuilder() {
    }

    public RequestContextBuilder(@Nonnull RequestContextBuilder prototype) {
        this.servletContext = prototype.servletContext;
        this.httpRequest = prototype.httpRequest;
        this.httpResponse = prototype.httpResponse;
        this.inboundMessageId = prototype.inboundMessageId;
        this.inboundMessageIssueInstant = prototype.inboundMessageIssueInstant;
        this.inboundMessageIssuer = prototype.inboundMessageIssuer;
        this.inboundMessage = prototype.inboundMessage;
        this.outboundMessageId = prototype.outboundMessageId;
        this.outboundMessageIssueInstant = prototype.outboundMessageIssueInstant;
        this.outboundMessageIssuer = prototype.outboundMessageIssuer;
        this.outboundMessage = prototype.outboundMessage;
        if (prototype.relyingPartyProfileConfigurations != null) {
            this.relyingPartyProfileConfigurations = new ArrayList<ProfileConfiguration>(prototype.relyingPartyProfileConfigurations);
        }
    }

    @Nonnull
    public RequestContextBuilder setServletContext(@Nullable ServletContext context) {
        this.servletContext = context;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setHttpRequest(@Nullable HttpServletRequest request) {
        this.httpRequest = request;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setHttpResponse(@Nullable HttpServletResponse response) {
        this.httpResponse = response;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessageId(@Nullable String id) {
        this.inboundMessageId = id;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessageIssueInstant(@Nullable Instant instant) {
        this.inboundMessageIssueInstant = instant;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessageIssuer(@Nullable String issuer) {
        this.inboundMessageIssuer = issuer;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setInboundMessage(@Nullable Object message) {
        this.inboundMessage = message;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setOutboundMessageId(@Nullable String id) {
        this.outboundMessageId = id;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setOutboundMessageIssueInstant(@Nullable Instant instant) {
        this.outboundMessageIssueInstant = instant;
        return this;
    }

    public RequestContextBuilder setOutboundMessageIssuer(@Nullable String issuer) {
        this.outboundMessageIssuer = issuer;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setOutboundMessage(@Nullable Object message) {
        this.outboundMessage = message;
        return this;
    }

    @Nonnull
    public RequestContextBuilder setRelyingPartyProfileConfigurations(@Nullable Collection<ProfileConfiguration> configs) {
        this.relyingPartyProfileConfigurations = configs;
        return this;
    }

    @Nonnull
    public RequestContext buildRequestContext() throws ComponentInitializationException {
        MockRequestContext context = new MockRequestContext();
        context.setExternalContext((ExternalContext)this.buildServletExternalContext());
        MutableAttributeMap scope = context.getConversationScope();
        scope.put("opensamlProfileRequestContext", (Object)this.buildProfileRequestContext());
        return context;
    }

    @Nonnull
    public ServletExternalContext buildServletExternalContext() {
        if (this.servletContext == null) {
            this.servletContext = new MockServletContext();
        }
        if (this.httpRequest == null) {
            MockHttpServletRequest hdr = new MockHttpServletRequest(this.servletContext);
            hdr.addHeader("Accept-Language", (Object)Locale.ENGLISH.getLanguage());
            this.httpRequest = hdr;
        }
        if (this.httpResponse == null) {
            this.httpResponse = new MockHttpServletResponse();
        }
        return new ServletExternalContext(this.servletContext, this.httpRequest, this.httpResponse);
    }

    @Nonnull
    public ProfileRequestContext buildProfileRequestContext() throws ComponentInitializationException {
        ProfileRequestContext profileContext = new ProfileRequestContext();
        profileContext.setInboundMessageContext(this.buildInboundMessageContext());
        profileContext.setOutboundMessageContext(this.buildOutboundMessageContext());
        this.buildRelyingPartyContext(profileContext);
        return profileContext;
    }

    @Nonnull
    protected MessageContext buildInboundMessageContext() {
        MessageContext context = new MessageContext();
        context.setMessage(this.inboundMessage);
        return context;
    }

    @Nonnull
    protected MessageContext buildOutboundMessageContext() {
        MessageContext context = new MessageContext();
        context.setMessage(this.outboundMessage);
        return context;
    }

    @Nonnull
    protected RelyingPartyContext buildRelyingPartyContext(@Nonnull ProfileRequestContext profileRequestContext) throws ComponentInitializationException {
        RelyingPartyContext rpCtx = (RelyingPartyContext)profileRequestContext.ensureSubcontext(RelyingPartyContext.class);
        if (Objects.equals(NO_VAL, this.inboundMessageIssuer) || this.inboundMessageIssuer == null) {
            rpCtx.setRelyingPartyId("http://sp.example.org");
        } else {
            rpCtx.setRelyingPartyId(this.inboundMessageIssuer);
        }
        RelyingPartyConfiguration rpConfig = this.buildRelyingPartyConfiguration();
        rpCtx.setConfiguration(rpConfig);
        rpCtx.setProfileConfig(this.selectProfileConfiguration(rpConfig.getProfileConfigurations(profileRequestContext)));
        return rpCtx;
    }

    @Nonnull
    protected RelyingPartyConfiguration buildRelyingPartyConfiguration() throws ComponentInitializationException {
        String responderId = Objects.equals(NO_VAL, this.outboundMessageIssuer) || this.outboundMessageIssuer == null ? "http://idp.example.org" : this.outboundMessageIssuer;
        if (this.relyingPartyProfileConfigurations == null) {
            this.relyingPartyProfileConfigurations = new ArrayList<ProfileConfiguration>();
        }
        assert (this.relyingPartyProfileConfigurations != null);
        List profileConfigs = this.relyingPartyProfileConfigurations.stream().filter(e -> e != null).collect(Collectors.toList());
        if (profileConfigs.isEmpty()) {
            profileConfigs.add(new MockProfileConfiguration("mock"));
        }
        BasicRelyingPartyConfiguration rp = new BasicRelyingPartyConfiguration();
        rp.setId("mock");
        rp.setIssuer(responderId);
        rp.setDetailedErrors(true);
        rp.setProfileConfigurations(profileConfigs);
        rp.initialize();
        return rp;
    }

    @Nullable
    protected ProfileConfiguration selectProfileConfiguration(@Nonnull Map<String, ProfileConfiguration> rpProfileConfigs) {
        return rpProfileConfigs.values().iterator().next();
    }
}

