/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.impl.testing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.saml.attribute.resolver.impl.SAML2NameIDAttributeDefinition;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.profile.context.ProfileRequestContext;

public final class TestSources {
    @Nonnull
    public static final String STATIC_CONNECTOR_NAME = "staticCon";
    @Nonnull
    public static final String DEPENDS_ON_ATTRIBUTE_NAME_ATTR = "at1";
    @Nonnull
    public static final String DEPENDS_ON_ATTRIBUTE_NAME_CONNECTOR = "ac1";
    @Nonnull
    public static final String DEPENDS_ON_SECOND_ATTRIBUTE_NAME = "at2";
    @Nonnull
    public static final String[] SECOND_ATTRIBUTE_VALUE_STRINGS = new String[]{"at2-Val1", "at2-Val2"};
    @Nonnull
    public static final StringAttributeValue[] SECOND_ATTRIBUTE_VALUE_RESULTS = new StringAttributeValue[]{new StringAttributeValue(SECOND_ATTRIBUTE_VALUE_STRINGS[0]), new StringAttributeValue(SECOND_ATTRIBUTE_VALUE_STRINGS[0])};
    @Nonnull
    public static final String COMMON_ATTRIBUTE_VALUE_STRING = "at1-Data";
    @Nonnull
    public static final StringAttributeValue COMMON_ATTRIBUTE_VALUE_RESULT = new StringAttributeValue("at1-Data");
    @Nonnull
    public static final String CONNECTOR_ATTRIBUTE_VALUE_STRING = "at1-Connector";
    @Nonnull
    public static final StringAttributeValue CONNECTOR_ATTRIBUTE_VALUE_RESULT = new StringAttributeValue("at1-Connector");
    @Nonnull
    public static final String ATTRIBUTE_ATTRIBUTE_VALUE_STRING = "at1-Attribute";
    @Nonnull
    public static final StringAttributeValue ATTRIBUTE_ATTRIBUTE_VALUE_RESULT = new StringAttributeValue("at1-Attribute");
    @Nonnull
    public static final String CONNECTOR_ATTRIBUTE_VALUE_REGEXP = "at1-(.+)or";
    @Nonnull
    public static final Pattern CONNECTOR_ATTRIBUTE_VALUE_REGEXP_PATTERN = Pattern.compile("at1-(.+)or");
    @Nonnull
    public static final StringAttributeValue CONNECTOR_ATTRIBUTE_VALUE_REGEXP_RESULT = new StringAttributeValue("Connect");
    @Nonnull
    public static final String TEST_PRINCIPAL = "PrincipalName";
    @Nonnull
    public static final String TEST_RELYING_PARTY = "RP1";
    @Nonnull
    public static final String TEST_AUTHN_METHOD = "AuthNmEthod";
    @Nonnull
    public static final String IDP_ENTITY_ID = "https://idp.example.org/idp";
    @Nonnull
    public static final String PRINCIPAL_ID = "PETER_THE_PRINCIPAL";
    @Nonnull
    public static final String SP_ENTITY_ID = "https://sp.example.org/sp";

    private TestSources() {
    }

    @Nonnull
    public static DataConnector populatedStaticConnector(@Nonnull List<IdPAttribute> attributes) throws ComponentInitializationException {
        StaticDataConnector connector = new StaticDataConnector();
        connector.setId(STATIC_CONNECTOR_NAME);
        connector.setValues(attributes);
        connector.initialize();
        return connector;
    }

    @Nonnull
    public static DataConnector populatedStaticConnector() throws ComponentInitializationException {
        ArrayList<IdPAttribute> attributeSet = new ArrayList<IdPAttribute>(2);
        IdPAttribute attr = new IdPAttribute(DEPENDS_ON_ATTRIBUTE_NAME_CONNECTOR);
        attr.setValues(List.of(new StringAttributeValue(COMMON_ATTRIBUTE_VALUE_STRING), new StringAttributeValue(CONNECTOR_ATTRIBUTE_VALUE_STRING)));
        attributeSet.add(attr);
        attr = new IdPAttribute(DEPENDS_ON_SECOND_ATTRIBUTE_NAME);
        attr.setValues(List.of(new StringAttributeValue(SECOND_ATTRIBUTE_VALUE_STRINGS[0]), new StringAttributeValue(SECOND_ATTRIBUTE_VALUE_STRINGS[1])));
        attributeSet.add(attr);
        return TestSources.populatedStaticConnector(attributeSet);
    }

    @Nonnull
    public static AttributeDefinition populatedStaticAttribute() throws ComponentInitializationException {
        return TestSources.populatedStaticAttribute(DEPENDS_ON_ATTRIBUTE_NAME_ATTR, 2);
    }

    @Nonnull
    public static AttributeDefinition populatedStaticAttribute(@Nonnull String attributeName, int attributeValuesCount) throws ComponentInitializationException {
        ArrayList<StringAttributeValue> valuesList = new ArrayList<StringAttributeValue>();
        if (attributeValuesCount > 0) {
            valuesList.add(new StringAttributeValue(COMMON_ATTRIBUTE_VALUE_STRING));
        }
        if (attributeValuesCount > 1) {
            valuesList.add(new StringAttributeValue(ATTRIBUTE_ATTRIBUTE_VALUE_STRING));
        }
        for (int i = 2; i < attributeValuesCount; ++i) {
            valuesList.add(new StringAttributeValue(ATTRIBUTE_ATTRIBUTE_VALUE_STRING + i));
        }
        IdPAttribute attr = new IdPAttribute(attributeName);
        attr.setValues(valuesList);
        return TestSources.populatedStaticAttribute(attr);
    }

    @Nonnull
    public static AttributeDefinition populatedStaticAttribute(@Nonnull IdPAttribute attribute) throws ComponentInitializationException {
        StaticAttributeDefinition definition = new StaticAttributeDefinition();
        definition.setId(attribute.getId());
        definition.setValue(attribute);
        definition.initialize();
        return definition;
    }

    @Nonnull
    public static AttributeDefinition nonStringAttributeDefiniton(@Nonnull String name) throws ComponentInitializationException {
        SAML2NameIDAttributeDefinition defn = new SAML2NameIDAttributeDefinition();
        defn.setId(name);
        ResolverAttributeDefinitionDependency depend = new ResolverAttributeDefinitionDependency(DEPENDS_ON_ATTRIBUTE_NAME_ATTR);
        defn.setAttributeDependencies(CollectionSupport.singleton((Object)depend));
        defn.initialize();
        return defn;
    }

    public static AttributeResolutionContext createResolutionContext(@Nonnull String principal, @Nonnull String issuerID, @Nonnull String recipientId) {
        ProfileRequestContext parent = new ProfileRequestContext();
        AttributeResolutionContext retVal = (AttributeResolutionContext)parent.ensureSubcontext(AttributeResolutionContext.class);
        retVal.setAttributeIssuerID(issuerID);
        retVal.setAttributeRecipientID(recipientId);
        retVal.setPrincipal(principal);
        retVal.ensureSubcontext(AttributeResolverWorkContext.class);
        return retVal;
    }

    @Nonnull
    public static ResolverAttributeDefinitionDependency makeAttributeDefinitionDependency(@Nonnull String attributeId) {
        ResolverAttributeDefinitionDependency retVal = new ResolverAttributeDefinitionDependency(attributeId);
        return retVal;
    }

    @Nonnull
    public static ResolverDataConnectorDependency makeDataConnectorDependency(@Nonnull String connectorId, @Nullable String attributeId) {
        ResolverDataConnectorDependency retVal = new ResolverDataConnectorDependency(connectorId);
        if (null == attributeId) {
            retVal.setAllAttributes(true);
        } else {
            retVal.setAttributeNames((Collection)CollectionSupport.singleton((Object)attributeId));
        }
        return retVal;
    }

    private static class StaticDataConnector
    extends AbstractDataConnector {
        @Nullable
        private Map<String, IdPAttribute> attributes;

        private StaticDataConnector() {
        }

        @Nullable
        @NonnullAfterInit
        public Map<String, IdPAttribute> getAttributes() {
            return this.attributes;
        }

        public void setValues(@Nullable @NullableElements Collection<IdPAttribute> newValues) {
            if (null == newValues) {
                this.attributes = null;
                return;
            }
            HashMap<String, IdPAttribute> map = new HashMap<String, IdPAttribute>(newValues.size());
            for (IdPAttribute attr : newValues) {
                if (null == attr) continue;
                map.put(attr.getId(), attr);
            }
            this.attributes = Map.copyOf(map);
        }

        @Nonnull
        protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
            assert (this.attributes != null);
            return this.attributes;
        }

        protected void doInitialize() throws ComponentInitializationException {
            super.doInitialize();
            if (null == this.attributes) {
                throw new ComponentInitializationException(this.getLogPrefix() + " No values set up.");
            }
        }
    }

    private static class StaticAttributeDefinition
    extends AbstractAttributeDefinition {
        @NonnullAfterInit
        private IdPAttribute value;

        private StaticAttributeDefinition() {
        }

        public void setValue(@Nullable IdPAttribute newAttribute) {
            this.checkSetterPreconditions();
            this.value = newAttribute;
        }

        @NonnullAfterInit
        public IdPAttribute getValue() {
            return this.value;
        }

        @Nonnull
        protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
            assert (this.value != null);
            return this.value;
        }

        protected void doInitialize() throws ComponentInitializationException {
            super.doInitialize();
            if (null == this.value) {
                throw new ComponentInitializationException(this.getLogPrefix() + " no attribute value set");
            }
        }
    }
}

