/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.taglib;

import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nullable;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import net.shibboleth.idp.ui.taglib.ServiceTagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePrivacyURLTag
extends ServiceTagSupport {
    private static final long serialVersionUID = -5857694815588394787L;
    private static Logger log = LoggerFactory.getLogger(ServicePrivacyURLTag.class);
    private static String linkText;

    public void setLinkText(@Nullable String text) {
        linkText = text;
    }

    @Nullable
    private String getPrivacyURLFromUIIinfo() {
        if (this.getRelyingPartyUIContext() == null) {
            return null;
        }
        return this.getRelyingPartyUIContext().getPrivacyStatementURL();
    }

    public int doEndTag() throws JspException {
        String privacyURL = this.getPrivacyURLFromUIIinfo();
        try {
            if (null == privacyURL) {
                JspWriter ew;
                BodyContent bc = this.getBodyContent();
                if (null != bc && (ew = bc.getEnclosingWriter()) != null) {
                    bc.writeOut((Writer)ew);
                }
            } else {
                this.pageContext.getOut().print(this.buildHyperLink(privacyURL, linkText));
            }
        }
        catch (IOException e) {
            log.warn("Error generating PrivacyStatementURL: {}", (Object)e.getMessage());
            throw new JspException("EndTag", (Throwable)e);
        }
        return super.doEndTag();
    }
}

