/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.ui.csrf;

import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.ui.csrf.CSRFToken;
import net.shibboleth.idp.ui.csrf.impl.SimpleCSRFToken;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;

@ThreadSafe
public final class CSRFTokenManager {
    @Nonnull
    private String csrfParameterName = "csrf_token";
    @Nonnull
    private IdentifierGenerationStrategy tokenGenerationStrategy = new SecureRandomIdentifierGenerationStrategy(20);
    @Nonnull
    private BiPredicate<CSRFToken, String> csrfTokenValidationPredicate = new DefaultCSRFTokenValidationPredicate();

    public void setTokenGenerationStrategy(@Nonnull IdentifierGenerationStrategy tokenStrategy) {
        this.tokenGenerationStrategy = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)tokenStrategy, (String)"tokenGenerationStrategy cannot be null");
    }

    public void setCsrfTokenValidationPredicate(@Nonnull BiPredicate<CSRFToken, String> tokenValidationPredicate) {
        this.csrfTokenValidationPredicate = (BiPredicate)Constraint.isNotNull(tokenValidationPredicate, (String)"CSRF token validation predicate can not be null");
    }

    public void setCsrfParameterName(@Nonnull @NotEmpty String parameterName) {
        this.csrfParameterName = Constraint.isNotEmpty((String)parameterName, (String)"CsrfParameterName cannot be null or empty");
    }

    @Nonnull
    public CSRFToken generateCSRFToken() {
        return new SimpleCSRFToken(this.tokenGenerationStrategy.generateIdentifier(), this.csrfParameterName);
    }

    public boolean isValidCSRFToken(@Nullable CSRFToken csrfToken, @Nullable String requestCsrfToken) {
        return this.csrfTokenValidationPredicate.test(csrfToken, requestCsrfToken);
    }

    private static class DefaultCSRFTokenValidationPredicate
    implements BiPredicate<CSRFToken, String> {
        private DefaultCSRFTokenValidationPredicate() {
        }

        @Override
        public boolean test(@Nullable CSRFToken csrfToken, @Nullable String requestCSRFToken) {
            if (csrfToken == null || requestCSRFToken == null) {
                return false;
            }
            return csrfToken.getToken().equals(requestCSRFToken);
        }
    }
}

