package org.openliberty;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.log4j.Logger;

public class LibUtils
{
	private static final Logger log = Logger.getLogger(LibUtils.class);
	
    /**
     * used by fixAxisGCSBug
     */
    private static final String BAD_GREG_STRING = "java.util.GregorianCalendar[time=";

    /**
     * Timecode formatter
     */
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    
    /**
     * http://issues.apache.org/jira/browse/AXIS2-1050?page=com.atlassian.jira.plugin.ext.subversion:subversion-commits-tabpanel
     * <br/>
     * It should be noted that this workaround has the potential to break a signed message if the axis
     * problem were detected and repaired inside a signed message or signed content
     * <br/>
     * {@link LibConstants} USE_AXIS_1_3_GREGORIAN_CALENDAR_SERIALIZATION_BUG_WORKAROUND is used to enable this feature
     * 
     * 
     * @param source
     * @return
     */
    public static String fixAxisGCSBug(String source)
    {
    	boolean debug = log.isDebugEnabled();
    	
        int badLoc = source.indexOf(BAD_GREG_STRING);
        while(-1!=badLoc)
        {
            int closingQuoteLoc = source.indexOf('"', badLoc);
            
            // extract the time and zone offset
            String timeStr = source.substring(source.indexOf('=', badLoc)+1,source.indexOf(',', badLoc));
            long time = Long.parseLong(timeStr);
            if(debug) log.debug("time"+time+", timeStr: "+timeStr);
            int offsetLoc = source.indexOf("offset=", badLoc);
            if(-1!=offsetLoc)
            {
                String offsetStr = source.substring(offsetLoc+7,source.indexOf(',', offsetLoc));
                long offset = Long.parseLong(offsetStr);
                if(debug) log.debug("offset: "+offset+", offsetStr: "+offsetStr);
                int dstLoc = source.indexOf("dstSavings=", offsetLoc);
                if(-1!=dstLoc)
                {
                    String dstStr = source.substring(dstLoc+11,source.indexOf(',', dstLoc));
                    long dst = Long.parseLong(dstStr);
                    if(debug) log.debug("dst: "+dst+", dstStr: "+dstStr);
                    offset = offset + dst;
                }
                time = time - offset;
            }   
            
            // extract and create a Date
            Date d = new Date(time);
            
            // format properly: 2008-05-09T19:16:56.582Z
            String formattedDate = format.format(d);
            if(debug) log.debug("formattedDate: "+formattedDate);
            
            // replace the bad date
            source = source.substring(0, badLoc)+formattedDate+source.substring(closingQuoteLoc);
            
            // find the next
            badLoc = source.indexOf(BAD_GREG_STRING);
        }
        
        return source;
    }
    
    
}
