package org.openliberty.wsc;

import java.net.URL;

import net.shibboleth.utilities.java.support.xml.XMLParserException;

import org.apache.log4j.Logger;
import org.openliberty.wsc.AuthenticationService.WSCExceptionType;
import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.disco.SecurityContext;
import org.openliberty.xmltooling.disco.SecurityMechID;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.openliberty.xmltooling.wsa.Metadata;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.soap.soap11.Envelope;

/**
 * This is a generic implementation of a service client that can be used to invoke
 * ID-WSF Messages.
 * 
 * @author asa
 *
 */
public class BaseServiceClientImpl extends BaseServiceClient
{
    private static Logger log = Logger.getLogger(BaseServiceClientImpl.class);
    
    public BaseServiceClientImpl()
    {
        super(null, null);
    }
    
    public BaseServiceClientImpl(DiscoveryService discoveryService, EndpointReference initialEndpointReference)
    {
        super(discoveryService, initialEndpointReference);
    }

    /**
     * Creates an EPR using the invicationURL and actionURI and selecting the NULL NULL 
     * security mechanism.  Then creates a WSFMessage and inserts the specified XMLObject 
     * into the body of the message
     * 
     * @param bodyChild
     * @param invocationURL
     * @param actionURI
     * @return
     * @throws WSCException
     */
    public Envelope invoke(XMLObject bodyChild, URL invocationURL, String actionURI) throws WSCException
    {
    	if(log.isDebugEnabled())
    	{
    		log.debug(invocationURL+" "+actionURI);
    	}
    	
        /**
         * Create a basic EPR with an address to support the instantiation of a WSFMessage
         */
        org.openliberty.xmltooling.wsa.Address address = new org.openliberty.xmltooling.wsa.Address();
        address.setValue(invocationURL.toString());

        Metadata metadata = new Metadata();
        SecurityContext sc = new SecurityContext();        
        metadata.getSecurityContexts().add(sc);    
        SecurityMechID securityMechID = new SecurityMechID();
        securityMechID.setValue(Konstantz.WSFSecurityMechanism.ID_WSF20_NULL_NULL.getUri());        
        sc.getSecurityMechIDs().add(securityMechID);
        
        EndpointReference epr = new EndpointReference();
        epr.setAddress(address);
        epr.setMetadata(metadata);
                
        this.setServiceEndpointReference(epr);
        
        WSFMessage message = null;
          
        try
        {
            message = WSFMessage.createWSFMessage(this, actionURI);
        }
        catch (XMLParserException e1)
        {
            e1.printStackTrace();
            return null;
        }
        catch (UnmarshallingException e1)
        {
            e1.printStackTrace();
            return null;            
        }
                
        message.getRequestEnvelope().getBody().getUnknownXMLObjects().add(bodyChild);

        try
        {
            message.invoke();
        }
        catch (Exception e)
        {
            e.printStackTrace();
            throw new WSCException(WSCExceptionType.AUTHENTICATION_SERVICE_INVOCATION_FAILURE.shortDesc);
        } 

        // return the envelope
        return message.getResponseEnvelope();
    }
    
     
    
    
}
