package org.openliberty.wsc;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.disco.RequestedService;

/**
 * This exception is thrown by methods within the WSCUtilities class when a discovery 
 * service is unable to produce an epr for the specified service with the specified
 * parameters.
 * 
 * @author asa
 *
 */
public class WSCNoServiceAvailableException extends WSCException
{
    
    private static final long serialVersionUID = 1L;

    public WSCNoServiceAvailableException(final String message)
    {
        super(message);
    }

    public static WSCNoServiceAvailableException exceptionForRequestedService(final RequestedService requestedService)
    {
        final StringBuffer exceptionBuffer = new StringBuffer();
        exceptionBuffer.append("The requested service was not available from the discoveryservice with the following parameters:\n");
        exceptionBuffer.append(OpenLibertyHelpers.prettyPrintXMLObject(requestedService));        
        return new WSCNoServiceAvailableException(exceptionBuffer.toString());
    }
}
