package org.openliberty.xmltooling;

import java.lang.reflect.Constructor;

import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;

/**
 * This is the default builder for the element classes that extend AbstractXMLObject
 * <p>
 * Object being built must:
 * <ul>
 * <li>be in the same package</li>
 * <li>have a local name that is equivalent to its classname</li>
 * <li>must extend AbstractXMLObject</li>
 * </ul>
 * <p>
 * @author asa
 *
 */
public abstract class OpenLibertyDefaultBuilder extends AbstractXMLObjectBuilder<AbstractXMLObject> 
{

    @Override
	public AbstractXMLObject buildObject(String namespaceURI, String localName, String namespacePrefix)
    {
        if(null!=localName)
        {
            // All of the classes that use this builder are named the same as the elements they 
            // represent, and exist in this package otherwise this will fail.  
            try
            {                
                Class<?> clazz = Class.forName(getClass().getPackage().getName()+"."+localName);
                Constructor<?> constructor = clazz.getConstructor(new Class[] {String.class,String.class,String.class });
                return (AbstractXMLObject)constructor.newInstance( new Object[] { namespaceURI, localName, namespacePrefix } );
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }

        // not a valid localName
        return null;
    }

}