package org.openliberty.xmltooling.disco;

import java.util.List;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * From liberty-idwsf-disco-svc-v2.0.xsd
 * 
 * "The data elements and types in this section are used to embellish
 * WS-Addressing Endpoint References (EPRs). They are placed in the
 * /wsa:EndpointReference/Metadata element. Specific usage and cardinalities are
 * stipulated in the Discovery Service v2.0 Specification."
 * 
 * @author tguion
 * 
 */
public class Action extends AbstractSignableXMLObject implements AttributeExtensibleXMLObject 
{
	
	public static String DEFAULT_ELEMENT_LOCAL_NAME = "Action";	
	public static QName DEFAULT_ELEMENT_NAME = QNameSupport.constructQName(Konstantz.DISCO_NS, DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.DISCO_PREFIX);

	
	/**
	 * Content: anyURI
	 */
	private String value;
	
	/**
	 * Support for AttributeExtensibleXMLObject interface
	 */
	private AttributeMap otherAttributes;	
	
    /**
     * Constructor
     * 
     * @param namespaceURI the namespace the element is in
     * @param elementLocalName the local name of the XML element this Object represents
     * @param namespacePrefix the prefix for the given namespace
     */
	protected Action(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);		
		otherAttributes = new AttributeMap(this);
	}

	public List<XMLObject> getOrderedChildren() 
	{
		return null;
	}	
	
    public void setValue(String value) 
    {
    	this.value = prepareForAssignment(this.value, value);
    }
    
    public String getValue() 
    { 
    	return value; 
    }
    
	/* (non-Javadoc)
	 * @see org.opensaml.xml.AttributeExtensibleXMLObject#getUnknownAttributes()
	 */
	public AttributeMap getUnknownAttributes() {
		return otherAttributes;
	}
    
}
