package org.openliberty.xmltooling.disco;

import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ActionMarshaller extends AbstractXMLObjectMarshaller
{

	@Override
	protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
	{
		Action action = (Action) xmlObject;	
		
        Attr attr;
        for(Entry<QName, String> entry: action.getUnknownAttributes().entrySet()){
            attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
            attr.setValue(entry.getValue());
            domElement.setAttributeNodeNS(attr);
            if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || action.getUnknownAttributes().isIDAttribute(entry.getKey())) {
                attr.getOwnerElement().setIdAttributeNode(attr, true);
            }
        }		
	}

	@Override
	protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
	{
		Action action = (Action) xmlObject;
		ElementSupport.appendTextContent(domElement, action.getValue());		
	}


}

