package org.openliberty.xmltooling.disco;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class ActionUnmarshaller extends AbstractXMLObjectUnmarshaller
{

	@Override
	protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
	{
		Action action = (Action) xmlObject;
        QName attribQName = QNameSupport.getNodeQName(attribute);
        if (attribute.isId()) {
        	action.getUnknownAttributes().registerID(attribQName);
        }
        action.getUnknownAttributes().put(attribQName, attribute.getValue());
	}

	@Override
	protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
	{
		// NO CHILDREN, NO NEED TO PROCESS
	}

	@Override
	protected void processElementContent(XMLObject xmlObject, String elementContent) 
	{
		Action action = (Action) xmlObject;
		action.setValue(elementContent);
	}


}
