package org.openliberty.xmltooling.disco;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class DiscoQuery extends AbstractSignableXMLObject implements ElementExtensibleXMLObject
{
	
	public static String LOCAL_NAME = "Query";
	
	private XMLObjectChildrenList<RequestedService> requestedServices;		

	private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects;

	
	protected DiscoQuery(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);		
		unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);		
	}

	public XMLObjectChildrenList<RequestedService> getRequestedServices() 
	{				
		if(null==requestedServices) requestedServices = new XMLObjectChildrenList<RequestedService>(this);
		return requestedServices;
	}		

    
	public List<XMLObject> getUnknownXMLObjects() 
	{
		return unknownXMLObjects;
	}

	public List<XMLObject> getOrderedChildren() 
	{
        List<XMLObject> children = new LinkedList<XMLObject>();
                
        if(null!=requestedServices) children.addAll(requestedServices);        
        children.addAll(unknownXMLObjects);        
        
        return Collections.unmodifiableList(children);
	}

    
    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownXMLObjects.subList(typeOrName);
    }

	
}
