package org.openliberty.xmltooling.disco;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.openliberty.xmltooling.sasl.Status;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class DiscoQueryResponse extends AbstractSignableXMLObject implements ElementExtensibleXMLObject 
{	
	
	public static String LOCAL_NAME = "QueryResponse";	
	
	private Status status;
    private XMLObjectChildrenList<EndpointReference> endpointReferences;	
    private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects;

	
	protected DiscoQueryResponse(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
		unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
		endpointReferences = new XMLObjectChildrenList<EndpointReference>(this);
	}
	
	public void setStatus(Status status)
	{
		this.status = status;
	}
	
	public Status getStatus()
	{
		return this.status;
	}
	
	public XMLObjectChildrenList<EndpointReference> getEndpointReferences()
	{
		return endpointReferences;
	}
		
	public List<XMLObject> getUnknownXMLObjects() 
	{
		return unknownXMLObjects;
	}

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownXMLObjects.subList(typeOrName);
    }
       
	public List<XMLObject> getOrderedChildren() 
	{
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.add(status);
        children.addAll(endpointReferences);        
        children.addAll(unknownXMLObjects);
        
        return Collections.unmodifiableList(children);
	}

}
