package org.openliberty.xmltooling.disco;

import java.util.List;

import javax.xml.namespace.QName;

import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class MetadataAbstract extends AbstractSignableXMLObject implements ElementExtensibleXMLObject 
{
	public static String LOCAL_NAME = "Abstract";

	private String value;
    private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects;
    
	protected MetadataAbstract(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
		unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);		
	}
	
	public List<XMLObject> getUnknownXMLObjects() 
	{
		return unknownXMLObjects;
	}

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownXMLObjects.subList(typeOrName);
    }
    
	public List<XMLObject> getOrderedChildren() 
	{
		return unknownXMLObjects;
	}

    public void setValue(String value) 
    {
    	this.value = prepareForAssignment(this.value, value);
    }
    
    public String getValue() 
    { 
    	return value; 
    }
	
	
}
