package org.openliberty.xmltooling.disco;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectChildrenList;

public class Options extends AbstractXMLObject
{

/*
<ds:Options>
	<ds:Option>urn:zenn:give-me</ds:Option>
	<ds:Option>urn:zenn:give-me:fun</ds:Option>
</ds:Options>
*/
	
	public static String LOCAL_NAME = "Options";

	/**
	 * Option children
	 */
    private XMLObjectChildrenList<Option> options;
	
    public Options()
    {
        super(Konstantz.DS_NS, Options.LOCAL_NAME, Konstantz.DS_PREFIX);
    }
        
    
    protected Options(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
		super(namespaceURI, elementLocalName, namespacePrefix);
		options = new XMLObjectChildrenList<Option>(this);
	}	
	
    public List<Option> getOptions()
    {
    	return options;
    }        
	
	public List<XMLObject> getOrderedChildren()
	{
        List<XMLObject> children = new LinkedList<XMLObject>();
        children.addAll(options);
        return Collections.unmodifiableList(children);
	}

}
