package org.openliberty.xmltooling.disco;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.openliberty.xmltooling.wsa.Action;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class RequestedService extends AbstractSignableXMLObject implements ElementExtensibleXMLObject
{
	
	public static String LOCAL_NAME = "RequestedService";
	
	private XMLObjectChildrenList<ServiceType> serviceTypes;		
	private XMLObjectChildrenList<ProviderID> providerIDs;
	private XMLObjectChildrenList<Options> optionss;
	private XMLObjectChildrenList<SecurityMechID> securityMechIDs;
	private XMLObjectChildrenList<Framework> frameworks;
	private XMLObjectChildrenList<Action> actions;

	private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects;

	public RequestedService()
    {
        super(Konstantz.DISCO_NS, RequestedService.LOCAL_NAME, Konstantz.DISCO_PREFIX);
        unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
    }
    
	protected RequestedService(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
		unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);		
	}

	public XMLObjectChildrenList<ServiceType> getServiceTypes() 
	{				
		if(null==serviceTypes) serviceTypes = new XMLObjectChildrenList<ServiceType>(this);
		return serviceTypes;
	}		
	public XMLObjectChildrenList<ProviderID> getProviderIDs() 
	{				
		if(null==providerIDs) providerIDs = new XMLObjectChildrenList<ProviderID>(this);
		return providerIDs;
	}
	public XMLObjectChildrenList<Options> getOptionss() 
	{				
		if(null==optionss) optionss = new XMLObjectChildrenList<Options>(this);
		return optionss;
	}
	public XMLObjectChildrenList<SecurityMechID> getSecurityMechIDs() 
	{				
		if(null==securityMechIDs) securityMechIDs = new XMLObjectChildrenList<SecurityMechID>(this);
		return securityMechIDs;
	}
	
	public XMLObjectChildrenList<Framework> getFrameworks()
	{
		if(null==frameworks) frameworks = new XMLObjectChildrenList<Framework>(this);
		return frameworks;
	}

	public XMLObjectChildrenList<Action> getActions()
	{
		if(null==actions) actions = new XMLObjectChildrenList<Action>(this);
		return actions;
	}
		
	public List<XMLObject> getUnknownXMLObjects() 
	{
		return unknownXMLObjects;
	}

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownXMLObjects.subList(typeOrName);
    }
    
	public List<XMLObject> getOrderedChildren() 
	{
        List<XMLObject> children = new LinkedList<XMLObject>();
                
        if(null!=serviceTypes) children.addAll(serviceTypes);
        if(null!=providerIDs) children.addAll(providerIDs);
        if(null!=optionss) children.addAll(optionss);
        if(null!=securityMechIDs) children.addAll(securityMechIDs);
        if(null!=frameworks) children.addAll(frameworks);
        if(null!=actions) children.addAll(actions);        
        
        children.addAll(unknownXMLObjects);
        
        return Collections.unmodifiableList(children);
	}

	
}
