package org.openliberty.xmltooling.disco;

// import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.openliberty.xmltooling.wsa.Action;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class RequestedServiceUnmarshaller extends AbstractXMLObjectUnmarshaller
{

    public RequestedServiceUnmarshaller()
    {
        //super(Konstantz.DISCO_NS, RequestedService.LOCAL_NAME);
    }
    
    
	@Override
	protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
	{

	}

	
	@Override
	protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
	{	
		RequestedService requestedService = (RequestedService) parentXMLObject;
		
		if(childXMLObject instanceof ServiceType) 
        {
			requestedService.getServiceTypes().add((ServiceType) childXMLObject);
        }
        else if(childXMLObject instanceof ProviderID) 
        {
        	requestedService.getProviderIDs().add((ProviderID) childXMLObject);
        }
		else if(childXMLObject instanceof Options) 
        {
			requestedService.getOptionss().add((Options) childXMLObject);
        }		
        else if(childXMLObject instanceof SecurityMechID) 
        {
        	requestedService.getSecurityMechIDs().add((SecurityMechID) childXMLObject);
        }		
        else if(childXMLObject instanceof Framework) 
        {
        	requestedService.getFrameworks().add((Framework) childXMLObject);
        }		
        else if(childXMLObject instanceof Action) 
        {
        	requestedService.getActions().add((Action) childXMLObject);
        }
        else        
        {
        	requestedService.getUnknownXMLObjects().add(childXMLObject);
        }	        
	}

	
	@Override
	protected void processElementContent(XMLObject xmlObject, String elementContent) 
	{
		// NO CONTENT
	}

}
