package org.openliberty.xmltooling.dst2_1;

import java.util.List;

import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;

/**
 * The value of this element specifies, in which format the requesting WSC would 
 * like to have the data, when querying for changes.
 * <p>
 * This class defines two enumerations that must be used by the ChangeFormat Element and 
 * the changeFormat Attribute.  It also models the ChangeFormat element
 * 
 * @author asa
 *
 */
public class ChangeFormat extends AbstractXMLObject
{
    
    public static final String LOCAL_NAME = "ChangeFormat";
    
    private ChangeFormatElement value;
    
    protected ChangeFormat(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    public ChangeFormatElement getValue()
    {
        return value;
    }
    
    public void setValue(ChangeFormatElement value)
    {
        this.value = prepareForAssignment(this.value, value);
    }
    
    
    public List<XMLObject> getOrderedChildren()
    {
        // no children
        return null;
    }

    
    /**
     * This enumeration is used for the ChangeFormat element
     * 
     * @author asa
     *
     */
    public enum ChangeFormatElement 
    {
        CHANGED_ELEMENTS("ChangedElements"), CURRENT_ELEMENTS("CurrentElements"), EMPTY(null);
        
        private String value;
        
        ChangeFormatElement(String value)
        {
            this.value = value;
        }
        
        public static ChangeFormatElement forValue(String value)
        {
            if(value!=null)
            {
                if(CHANGED_ELEMENTS.value().equals(value)) return CHANGED_ELEMENTS;
                else if(CURRENT_ELEMENTS.value().equals(value)) return CURRENT_ELEMENTS;
            }            
            return EMPTY;
        }
        
        public String value() { return value; }
        
    }

    /**
     * This enumeration is used for the changeFormat attribute
     * 
     * @author asa
     *
     */
    public enum ChangeFormatAttribute
    {
        CHANGED_ELEMENTS("ChangedElements"), CURRENT_ELEMENTS("CurrentElements"), ALL("All"), EMPTY(null);
        
        private String value;
        
        ChangeFormatAttribute(String value)
        {
            this.value = value;
        }
        
        public static ChangeFormatAttribute forValue(String value)
        {
            if(value!=null)
            {
                if(CHANGED_ELEMENTS.value().equals(value)) return CHANGED_ELEMENTS;
                else if(CURRENT_ELEMENTS.value().equals(value)) return CURRENT_ELEMENTS;
                else if(ALL.value().equals(value)) return ALL;
            }            
            return EMPTY;
        }
        
        public String value() { return value; }
        
    }


    

}
/*
  <xs:element name="ChangeFormat">
    <xs:simpleType>
      <xs:restriction base="xs:string">
        <xs:enumeration value="ChangedElements"/>
        <xs:enumeration value="CurrentElements"/>
      </xs:restriction>
    </xs:simpleType>
  </xs:element>

  <xs:attribute name="changeFormat">
    <xs:simpleType>
      <xs:restriction base="xs:string">
        <xs:enumeration value="ChangedElements"/>
        <xs:enumeration value="CurrentElements"/>
        <xs:enumeration value="All"/>
      </xs:restriction>
    </xs:simpleType>
  </xs:attribute>
  
*/
