package org.openliberty.xmltooling.dst2_1;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class CommonAttributes 
{

	
	
    public static String MODIFICATION_TIME = "modificationTime";
    public static String ID = "id";

    private String id;
    private DateTime modificationTime; 

    /**
     * This is a convenience method used by any Marshaller that is marshalling 
     * an object that has CommonAttributes
     *
     */
    public void marshallAttributes(Element domElement)
    {

        if(id!=null) 
        {
            domElement.setAttributeNS(null, CommonAttributes.ID, id);
            domElement.setIdAttributeNS(null, CommonAttributes.ID, true);
        }

        if(modificationTime!=null)
        {
            String modificationTimeStr = OpenLibertyHelpers.stringForDateTime(modificationTime);
            domElement.setAttributeNS(null, CommonAttributes.MODIFICATION_TIME, modificationTimeStr);
        }
    }

    /**
     * This method assists the unmarshaller, adding an XML Attribute to 
     * the CommonAttributes object
     *     
     * @param attribute the attribute to set
     * 
     * @return whether an attribute was found and set
     */
    public boolean processAttribute(Attr attribute, AbstractXMLObject abstractXMLObject)
    {

        if (attribute.getLocalName().equals(ID)) 
        {
            this.setId(attribute.getValue(), abstractXMLObject);
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
            return true;
        }
        else if (attribute.getLocalName().equals(MODIFICATION_TIME)) 
        {            
            this.setModificationTime(OpenLibertyHelpers.dateTimeForString(attribute.getValue()), abstractXMLObject);
            return true;
        }
        
        return false;

    }
    
    
    
    
    /**
     * xs:string
     * <p>
     * ID-WSF Utility v1.1 IDType
     * <p>
     * This type should be used to provide IDs to components that have IDs 
     * that may not be scoped within the local xml instance document.
     * @return an id that is valid outside of the scope of the XML document
     */
    public String getId()
    {
        return id;
    }

    /**
     * xs:string
     * <p>
     * @param id 
     */
    public void setId(String id, AbstractXMLObject abstractXMLObject)
    {
        this.id = OpenLibertyHelpers.prepareForAssignment(this.id, id, abstractXMLObject);
    }

    /**
     * xs:dateTime
     * <p>
     * @return the time that the element was modified
     */
    public DateTime getModificationTime()
    {
        return this.modificationTime;
    }

    /**
     * xs:dateTime
     * <p>
     * @param modificationTime 
     */
    public void setModificationTime(DateTime modificationTime, AbstractXMLObject abstractXMLObject)
    {
        this.modificationTime = OpenLibertyHelpers.prepareForAssignment(this.modificationTime, modificationTime, OpenLibertyHelpers.getDefaultDateFormatter(), abstractXMLObject);		
    }


}
