package org.openliberty.xmltooling.dst2_1;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;


/**
 * 
 * 
 * <pre>
 *   &lt;xs:attributeGroup name="CreateItemAttributeGroup"&gt;
 *     &lt;xs:attribute ref="dst:objectType" use="optional"/&gt;
 *     &lt;xs:attribute name="id" use="optional" type="xs:ID"/&gt;
 *     &lt;xs:attribute ref="lu:itemID" use="optional"/&gt;
 *   &lt;/xs:attributeGroup&gt;
 * </pre>
 * @author asa
 *
 */
public class CreateItemAttributeGroup
{

    // Attribute Names
    public static final String ITEM_ID = "itemID";
    public static final String ID = "id";
    public static final String OBJECT_TYPE = "objectType";

    // Attributes
    private String id;
    private String objectType;  // dst:objectType, xs:NCName
    private String itemID;  // lu:itemID
    
    
    /**
     * This is a convenience method used by any Marshaller that is marshalling 
     * an object that has a CreateItemAttributeGroup
     *
     */
    public void marshallAttributes(Element domElement)
    {
        
        if(itemID!=null) 
        {
            domElement.setAttributeNS(null, ITEM_ID, itemID);
        }

        if(id!=null)
        {
            domElement.setAttributeNS(null, ID, id);
            //domElement.setIdAttributeNS(null, ID, true);
        }

        if(objectType!=null)
        {
            domElement.setAttributeNS(null, OBJECT_TYPE, objectType);
        }

    }

    /**
     * This method assists the unmarshaller, adding an XML Attribute to 
     * the CreateItemAttributeGroup object
     *     
     * @param attribute the attribute to set
     * 
     * @return whether an attribute was found and set
     */
    public boolean processAttribute(Attr attribute, AbstractXMLObject abstractXMLObject)
    {

        if (attribute.getLocalName().equals(ID)) 
        {
            this.setId(attribute.getValue(), abstractXMLObject);
            // attribute.getOwnerElement().setIdAttributeNode(attribute, true);
            return true;
        }
        else if (attribute.getLocalName().equals(ITEM_ID)) 
        {
            this.setItemID(attribute.getValue(), abstractXMLObject);
            return true;
        }
        else if (attribute.getLocalName().equals(OBJECT_TYPE)) 
        {
            this.setObjectType(attribute.getValue(), abstractXMLObject);
            return true;
        }

        
        return false;

    }
    

    
    
    
    
    
    
    public void setItemID(String itemID, AbstractXMLObject abstractXMLobject)
    {
        this.itemID = OpenLibertyHelpers.prepareForAssignment(this.itemID, itemID, abstractXMLobject);
    }

    public String getItemID()
    {
        return this.itemID;
    }

    public void setId(String id, AbstractXMLObject abstractXMLobject)
    {
        this.id = OpenLibertyHelpers.prepareForAssignment(this.id, id, abstractXMLobject);
    }
    
    public String getId()
    {
        return id;
    }
    
    public void setObjectType(String objectType, AbstractXMLObject abstractXMLobject)
    {
        this.objectType = OpenLibertyHelpers.prepareForAssignment(this.objectType, objectType, abstractXMLobject);
    }
    
    public String getObjectType()
    {
        return objectType;
    }
    
    
}
