package org.openliberty.xmltooling.dst2_1;

import java.util.Date;
import java.util.List;

import javax.xml.namespace.QName;

import org.joda.time.DateTime;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class DSTDate extends AbstractSignableXMLObject
{
        
    private LeafAttributes attributes;
    private DateTime value;               // xs:date

    
    public DSTDate(QName qName) 
    {
        super(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());     
        attributes = new LeafAttributes();
    }
    
    public DSTDate(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);     
        attributes = new LeafAttributes();
    }

    public LeafAttributes attributes()
    {
        return attributes;
    }

    public void setDateValue(Date value)
    {
        setValue(new DateTime(value));
    }
    
    public Date getDateValue()
    {
        if(null!=value) return value.toDate();
        else return null;
    }
    
    public void setValue(DateTime value) 
    {
        this.value = prepareForAssignment(this.value, value);
    }

    public DateTime getValue() 
    { 
        return value; 
    }

    // no child elements
    public List<XMLObject> getOrderedChildren() 
    {
        return null;
    }
    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DSTDate>
    {
        @Override
        public DSTDate buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new DSTDate(namespaceURI, localName, namespacePrefix);
        }        
    }

    

}

