package org.openliberty.xmltooling.dst2_1;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class DSTDateUnmarshaller extends AbstractXMLObjectUnmarshaller
{
    
    
    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        DSTDate dSTDate = (DSTDate) xmlObject;
        dSTDate.setValue(OpenLibertyHelpers.dateTimeForString(elementContent));
    }

    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        DSTDate dSTDate = (DSTDate) xmlObject;        
        dSTDate.attributes().processAttribute(attribute, dSTDate);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        // There are no child elements 
    }

}
