package org.openliberty.xmltooling.dst2_1;

import java.util.List;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class DSTInteger extends AbstractSignableXMLObject
{
    
    private LeafAttributes attributes;
    private Integer value;

    public DSTInteger(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);     
        attributes = new LeafAttributes();      
    }

    public LeafAttributes attributes()
    {
        return attributes;
    }

    public void setValue(Integer value) 
    {
        this.value = prepareForAssignment(this.value, value);
    }

    public Integer getValue() 
    { 
        return value; 
    }

    // no child elements
    public List<XMLObject> getOrderedChildren() 
    {
        return null;
    }




}

