package org.openliberty.xmltooling.dst2_1;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Element;

public class DSTIntegerMarshaller extends AbstractXMLObjectMarshaller
{

    @Override
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
    {
        DSTInteger dSTInteger = (DSTInteger)xmlObject;
        dSTInteger.attributes().marshallAttributes(domElement);
    }

    @Override
    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
    {
        DSTInteger dSTInteger = (DSTInteger) xmlObject;
        Integer value = dSTInteger.getValue();
        if(null!=value)
        {
            ElementSupport.appendTextContent(domElement, value.toString());
        }
        else 
        {
            ElementSupport.appendTextContent(domElement, "");
        }
    }



}
