package org.openliberty.xmltooling.dst2_1;

import org.apache.commons.lang.math.NumberUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class DSTIntegerUnmarshaller extends AbstractXMLObjectUnmarshaller
{

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        DSTInteger dSTInteger = (DSTInteger) xmlObject;
        if(NumberUtils.isNumber(elementContent))
        {
            dSTInteger.setValue(NumberUtils.createInteger(elementContent));
        }
        else 
        {
            dSTInteger.setValue(null);
        }
    }

    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        DSTInteger dSTInteger = (DSTInteger) xmlObject;
        dSTInteger.attributes().processAttribute(attribute, dSTInteger);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        // There are no child elements 
    }

}
