package org.openliberty.xmltooling.dst2_1;

import java.util.List;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class DSTLocalizedString extends AbstractSignableXMLObject
{

	private LocalizedLeafAttributes attributes;
	private String value;

    public DSTLocalizedString(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
		attributes = new LocalizedLeafAttributes();
	}

	public LocalizedLeafAttributes attributes()
	{
		return attributes;
	}

	public void setValue(String value) 
	{
		this.value = prepareForAssignment(this.value, value);
	}

	public String getValue() 
	{ 
		return value; 
	}

	// no child elements
	public List<XMLObject> getOrderedChildren() 
	{
		return null;
	}


}
