package org.openliberty.xmltooling.dst2_1;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Element;

public class DSTLocalizedStringMarshaller extends AbstractXMLObjectMarshaller
{

    @Override
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
    {
        DSTLocalizedString dSTLocalizedString = (DSTLocalizedString)xmlObject;
        dSTLocalizedString.attributes().marshallAttributes(domElement);
    }

    @Override
    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
    {
        DSTLocalizedString dSTLocalizedString = (DSTLocalizedString) xmlObject;
        ElementSupport.appendTextContent(domElement, dSTLocalizedString.getValue());
    }

}
