package org.openliberty.xmltooling.dst2_1;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class DSTLocalizedStringUnmarshaller extends AbstractXMLObjectUnmarshaller
{

    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        DSTLocalizedString dSTLocalizedString = (DSTLocalizedString) xmlObject;
        dSTLocalizedString.setValue(elementContent);
    }

    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
    {
        DSTLocalizedString dSTLocalizedString = (DSTLocalizedString) xmlObject;
        dSTLocalizedString.attributes().processAttribute(attribute, dSTLocalizedString);
    }

    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
    {
        // There are no child elements 
    }

}
