package org.openliberty.xmltooling.dst2_1;

import java.util.List;

import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * 
 * xs:gMonthDay
 * 
 * @author asa
 *
 */
public class DSTMonthDay extends AbstractSignableXMLObject
{
    
    private static String defaultDSTMonthDayFormat = "--MM-dd'Z'";    
    private static DateTimeFormatter dSTMonthDayFormatFormatter;
            
    private LeafAttributes attributes;
    private DateTime value;               // xs:gMonthDay

    public DSTMonthDay(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix); 
        attributes = new LeafAttributes();
    }

    public LeafAttributes attributes()
    {
        return attributes;
    }

    public void setValue(DateTime value) 
    {
        this.value = prepareForAssignment(this.value, value);
    }

    public DateTime getValue() 
    { 
        return value; 
    }

    // no child elements
    public List<XMLObject> getOrderedChildren() 
    {
        return null;
    }

    /**
     * Returns a joda DateTimeFormatter for parsing and printing a DateTime using
     * xs.gMonthDay format "--MM-DDZ"
     * 
     * @return 
     */
    public static DateTimeFormatter getDSTMonthDayFormatter() 
    {
        if (dSTMonthDayFormatFormatter == null) 
        {
            DateTimeFormatter formatter = DateTimeFormat.forPattern(defaultDSTMonthDayFormat);
            dSTMonthDayFormatFormatter = formatter.withChronology(ISOChronology.getInstanceUTC());
        }
        return dSTMonthDayFormatFormatter;
    }



}

