package org.openliberty.xmltooling.dst2_1;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Element;

public class DSTMonthDayMarshaller extends AbstractXMLObjectMarshaller
{
    
    @Override
    protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
    {
        DSTMonthDay dSTMonthDay = (DSTMonthDay)xmlObject;
        dSTMonthDay.attributes().marshallAttributes(domElement);
    }

    @Override
    protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
    {
        DSTMonthDay dSTMonthDay = (DSTMonthDay) xmlObject;
        DateTime value = dSTMonthDay.getValue();
        if(null!=value)
        {
            ElementSupport.appendTextContent(domElement, DSTMonthDay.getDSTMonthDayFormatter().print(value));
        }
        else
        {
            ElementSupport.appendTextContent(domElement, "");
        }
    }   

    
    
}
