package org.openliberty.xmltooling.dst2_1;

import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * Base class for all Data Services Template String types
 * 
 * @author asa
 *
 */
public class DSTString extends AbstractSignableXMLObject
{

	private LeafAttributes attributes;
	private String value;

	
	public DSTString(String elementLocalName, String value)
	{
	    super(Konstantz.DST_NS, elementLocalName, Konstantz.DST_PREFIX);
	    this.setValue(value);
        attributes = new LeafAttributes();      
	}
	
	public DSTString(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);		
		attributes = new LeafAttributes();		
	}

	public LeafAttributes attributes()
	{
		return attributes;
	}

	public void setValue(String value) 
	{
		this.value = prepareForAssignment(this.value, value);
	}

	public String getValue() 
	{ 
		return value; 
	}

	// no child elements
	public List<XMLObject> getOrderedChildren() 
	{
		return null;
	}


    
    /**
     * Static Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<DSTString>
    {
        @Override
        public DSTString buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new DSTString(namespaceURI, localName, namespacePrefix);
        }        
    }

    

}


